/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.util.ClassUtils;

public class MethodInvoker {
    private Class targetClass;
    private Object targetObject;
    private String targetMethod;
    private String staticMethod;
    private Object[] arguments = new Object[0];
    private Method methodObject;
    static /* synthetic */ Class class$java$lang$Object;

    public void setTargetClass(Class clazz) {
        this.targetClass = clazz;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetObject(Object object) {
        this.targetObject = object;
        if (object != null) {
            this.targetClass = object.getClass();
        }
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetMethod(String string) {
        this.targetMethod = string;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setStaticMethod(String string) {
        this.staticMethod = string;
    }

    public void setArguments(Object[] objectArray) {
        this.arguments = objectArray != null ? objectArray : new Object[]{};
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void prepare() throws ClassNotFoundException, NoSuchMethodException {
        block7: {
            Object object;
            String string;
            if (this.staticMethod != null) {
                int n = this.staticMethod.lastIndexOf(46);
                if (n == -1 || n == this.staticMethod.length()) {
                    throw new IllegalArgumentException("staticMethod must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.myExampleMethod'");
                }
                string = this.staticMethod.substring(0, n);
                object = this.staticMethod.substring(n + 1);
                this.targetClass = this.resolveClassName(string);
                this.targetMethod = object;
            }
            Class clazz = this.getTargetClass();
            string = this.getTargetMethod();
            if (clazz == null) {
                throw new IllegalArgumentException("Either 'targetClass' or 'targetObject' is required");
            }
            if (string == null) {
                throw new IllegalArgumentException("Property 'targetMethod' is required");
            }
            object = this.getArguments();
            Class[] classArray = new Class[((Object[])object).length];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                classArray[i] = object[i] != null ? object[i].getClass() : (class$java$lang$Object == null ? MethodInvoker.class$("java.lang.Object") : class$java$lang$Object);
            }
            try {
                this.methodObject = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.methodObject = this.findMatchingMethod();
                if (this.methodObject != null) break block7;
                throw noSuchMethodException;
            }
        }
    }

    protected Class resolveClassName(String string) throws ClassNotFoundException {
        return ClassUtils.forName(string);
    }

    protected Method findMatchingMethod() {
        String string = this.getTargetMethod();
        Object[] objectArray = this.getArguments();
        int n = objectArray.length;
        Method[] methodArray = this.getTargetClass().getMethods();
        Method method = null;
        int n2 = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            Class<?>[] classArray = method2.getParameterTypes();
            int n3 = classArray.length;
            if (!method2.getName().equals(string) || n3 != n) continue;
            boolean bl = true;
            for (int j = 0; j < n3 && bl; ++j) {
                bl = bl && ClassUtils.isAssignableValue(classArray[j], objectArray[j]);
            }
            if (!bl) continue;
            method = method2;
            ++n2;
        }
        if (n2 == 1) {
            return method;
        }
        return null;
    }

    public Method getPreparedMethod() throws IllegalStateException {
        if (this.methodObject == null) {
            throw new IllegalStateException("prepare() must be called prior to invoke() on MethodInvoker");
        }
        return this.methodObject;
    }

    public boolean isPrepared() {
        return this.methodObject != null;
    }

    public Object invoke() throws InvocationTargetException, IllegalAccessException {
        Object object = this.getTargetObject();
        Method method = this.getPreparedMethod();
        if (object == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Target method must not be non-static without a target");
        }
        return method.invoke(object, this.getArguments());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

