/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.procimg;

import java.util.Vector;
import net.wimpi.modbus.procimg.DigitalIn;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImageImplementation;
import net.wimpi.modbus.procimg.Register;

public class SimpleProcessImage
implements ProcessImageImplementation {
    protected Vector m_DigitalInputs = new Vector();
    protected Vector m_DigitalOutputs = new Vector();
    protected Vector m_InputRegisters = new Vector();
    protected Vector m_Registers = new Vector();
    protected boolean m_Locked = false;

    public boolean isLocked() {
        return this.m_Locked;
    }

    public void setLocked(boolean locked) {
        this.m_Locked = locked;
    }

    @Override
    public void addDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.m_DigitalInputs.addElement(di);
        }
    }

    @Override
    public void removeDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.m_DigitalInputs.removeElement(di);
        }
    }

    @Override
    public void setDigitalIn(int ref, DigitalIn di) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_DigitalInputs.setElementAt(di, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public DigitalIn getDigitalIn(int ref) throws IllegalAddressException {
        try {
            return (DigitalIn)this.m_DigitalInputs.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getDigitalInCount() {
        return this.m_DigitalInputs.size();
    }

    @Override
    public DigitalIn[] getDigitalInRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_DigitalInputs.size()) {
            throw new IllegalAddressException();
        }
        DigitalIn[] dins = new DigitalIn[count];
        int i = 0;
        while (i < dins.length) {
            dins[i] = this.getDigitalIn(ref + i);
            ++i;
        }
        return dins;
    }

    @Override
    public void addDigitalOut(DigitalOut _do) {
        if (!this.isLocked()) {
            this.m_DigitalOutputs.addElement(_do);
        }
    }

    @Override
    public void removeDigitalOut(DigitalOut _do) {
        if (!this.isLocked()) {
            this.m_DigitalOutputs.removeElement(_do);
        }
    }

    @Override
    public void setDigitalOut(int ref, DigitalOut _do) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_DigitalOutputs.setElementAt(_do, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public DigitalOut getDigitalOut(int ref) throws IllegalAddressException {
        try {
            return (DigitalOut)this.m_DigitalOutputs.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getDigitalOutCount() {
        return this.m_DigitalOutputs.size();
    }

    @Override
    public DigitalOut[] getDigitalOutRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_DigitalOutputs.size()) {
            throw new IllegalAddressException();
        }
        DigitalOut[] douts = new DigitalOut[count];
        int i = 0;
        while (i < douts.length) {
            douts[i] = this.getDigitalOut(ref + i);
            ++i;
        }
        return douts;
    }

    @Override
    public void addInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.m_InputRegisters.addElement(reg);
        }
    }

    @Override
    public void removeInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.m_InputRegisters.removeElement(reg);
        }
    }

    @Override
    public void setInputRegister(int ref, InputRegister reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_InputRegisters.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public InputRegister getInputRegister(int ref) throws IllegalAddressException {
        try {
            return (InputRegister)this.m_InputRegisters.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getInputRegisterCount() {
        return this.m_InputRegisters.size();
    }

    @Override
    public InputRegister[] getInputRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_InputRegisters.size()) {
            throw new IllegalAddressException();
        }
        InputRegister[] iregs = new InputRegister[count];
        int i = 0;
        while (i < iregs.length) {
            iregs[i] = this.getInputRegister(ref + i);
            ++i;
        }
        return iregs;
    }

    @Override
    public void addRegister(Register reg) {
        if (!this.isLocked()) {
            this.m_Registers.addElement(reg);
        }
    }

    @Override
    public void removeRegister(Register reg) {
        if (!this.isLocked()) {
            this.m_Registers.removeElement(reg);
        }
    }

    @Override
    public void setRegister(int ref, Register reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_Registers.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public Register getRegister(int ref) throws IllegalAddressException {
        try {
            return (Register)this.m_Registers.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getRegisterCount() {
        return this.m_Registers.size();
    }

    @Override
    public Register[] getRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_Registers.size()) {
            throw new IllegalAddressException();
        }
        Register[] iregs = new Register[count];
        int i = 0;
        while (i < iregs.length) {
            iregs[i] = this.getRegister(ref + i);
            ++i;
        }
        return iregs;
    }
}

