/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.util.CRCUtil;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SerialHandler
implements IComUSBHandler,
ICommunicateDevice {
    protected static final Logger logger = Logger.getLogger(SerialHandler.class);
    private boolean isCrcCheck = false;
    private CommPortIdentifier portId;
    private InputStream input = null;
    private OutputStream output = null;
    private SerialPort serialPort;
    private int _errorcount = 0;
    private boolean isUseCRC = false;
    protected AbstractProcessor notifyProcesser;

    private void clearbuffer() {
        try {
            int buflen = this.input.available();
            while (buflen > 0) {
                this.input.read();
                --buflen;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SerialHandler(CommPortIdentifier portId) throws Exception {
        this.portId = portId;
        int baudRate = 2400;
        this.serialPort = (SerialPort)portId.open("Arista", baudRate);
        try {
            this.serialPort.enableReceiveTimeout(1200);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        this.input = this.serialPort.getInputStream();
        this.output = this.serialPort.getOutputStream();
    }

    @Override
    public synchronized String excuteSimpleCommand(String command) {
        String returnValue;
        block9: {
            boolean result = true;
            int time = 0;
            returnValue = "";
            try {
                try {
                    while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                        this.clearbuffer();
                        byte[] bytes = command.getBytes();
                        this.output.write(bytes);
                        this.output.write(13);
                        this.output.flush();
                        long end = System.currentTimeMillis() + 3000L;
                        StringBuilder sb = new StringBuilder();
                        boolean flag = false;
                        while (System.currentTimeMillis() < end) {
                            int ch = this.input.read();
                            if (ch < 0) continue;
                            if (ch != 13) {
                                sb.append((char)ch);
                                continue;
                            }
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            result = false;
                        }
                        returnValue = sb.toString();
                        ++time;
                    }
                }
                catch (Exception ex) {
                    result = false;
                    this.countErrorandNotifyProcesser(result);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.countErrorandNotifyProcesser(result);
                throw throwable;
            }
            this.countErrorandNotifyProcesser(result);
        }
        Debug.debug(command, returnValue);
        return returnValue;
    }

    public void setBaudRate1200() {
        try {
            this.serialPort.setSerialPortParams(1200, 8, 1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized String excuteCommand(String command, boolean isResponse) {
        String returnValue;
        block10: {
            boolean result = true;
            returnValue = "";
            int time = 0;
            try {
                try {
                    while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                        this.clearbuffer();
                        byte[] bytes = command.getBytes();
                        this.output.write(bytes);
                        this.output.write(13);
                        this.output.flush();
                        if (!isResponse) {
                            returnValue = null;
                            break;
                        }
                        long end = System.currentTimeMillis() + 3000L;
                        StringBuilder sb = new StringBuilder();
                        boolean flag = false;
                        while (System.currentTimeMillis() < end) {
                            int ch = this.input.read();
                            if (ch < 0) continue;
                            if (ch != 13) {
                                sb.append((char)ch);
                                continue;
                            }
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            result = false;
                        }
                        returnValue = sb.toString();
                        ++time;
                        if (!this.isCrcCheck) continue;
                        returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
                    }
                }
                catch (Exception ex) {
                    result = false;
                    this.countErrorandNotifyProcesser(result);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.countErrorandNotifyProcesser(result);
                throw throwable;
            }
            this.countErrorandNotifyProcesser(result);
        }
        Debug.debug(command, returnValue);
        return returnValue;
    }

    private void countErrorandNotifyProcesser(boolean success) {
        this._errorcount = success ? 0 : ++this._errorcount;
        if (this._errorcount >= 3 && this.notifyProcesser != null) {
            System.out.println("---------communication exception---------" + this._errorcount);
            this.notifyProcesser.close();
        }
    }

    @Override
    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDeviceName() {
        String portName = this.portId.getName();
        int index = portName.lastIndexOf("/");
        if (index > 0) {
            portName = portName.substring(index + 1, portName.length());
        }
        return portName;
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    @Override
    public int getMpptTrackNumber() {
        int mpptTrackNumber = 2;
        try {
            String result = this.excuteCommand("QPIRI", true);
            if (result != null && !"".equals(result) && !result.equals("QPIRI")) {
                String[] arr = result.split(" ");
                mpptTrackNumber = Integer.parseInt(arr[7]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        String serialno = "";
        String serialnoStr = "";
        try {
            int i = 0;
            while (i < 3) {
                serialnoStr = this.excuteCommand("QID", true);
                if (!(serialnoStr == null || "".equals(serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK") || serialnoStr.equals("QID"))) {
                    serialno = serialnoStr.substring(1);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialno;
    }

    @Override
    public String getModeType() {
        String machineTypeStr = "";
        try {
            String qpiriStr = this.excuteCommand("QPIRI", true);
            if (!("".equals(qpiriStr) || qpiriStr.equals("(NAK") || qpiriStr.equals("QPIRI"))) {
                String[] ratingInfo = qpiriStr.split(" ");
                machineTypeStr = ratingInfo[8];
                return machineTypeStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineTypeStr;
    }

    @Override
    public String getDeviceModel() {
        String _deviceModel = "";
        try {
            String qdmStr = this.excuteCommand("QDM", true);
            if (!("".equals(qdmStr) || qdmStr.equals("(NAK") || qdmStr.equals("QDM"))) {
                _deviceModel = qdmStr = qdmStr.substring(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _deviceModel;
    }

    @Override
    public void setCrcCheck(boolean isCrcCheck) {
        this.isCrcCheck = isCrcCheck;
    }

    public static void main(String[] args) {
        long curtime = 0L;
        String[] commands = new String[]{"QEH2013081409218"};
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)en.nextElement();
            System.out.println(portId.getName());
            try {
                SerialHandler comm = new SerialHandler(portId);
                comm.setCrcCheck(true);
                curtime = System.currentTimeMillis();
                String[] stringArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    String cmd = stringArray[n2];
                    String result = comm.excuteCommand(cmd, true);
                    System.out.println("cmd:" + cmd + "=" + result + " length=" + result.length());
                    ++n2;
                }
                System.out.println(System.currentTimeMillis() - curtime);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String excuteSetCommand(String command, boolean isResponse) {
        return null;
    }

    @Override
    public boolean isUseCRC() {
        return this.isUseCRC;
    }

    @Override
    public void setUseCRC(boolean isUseCRC) {
        this.isUseCRC = isUseCRC;
    }

    @Override
    public String getModelName() {
        String modelName = "";
        try {
            String qgmn = this.excuteCommand("QGMN", true);
            if (!("".equals(qgmn) || qgmn.equals("(NAK") || qgmn.equals("QGMN"))) {
                modelName = qgmn = qgmn.substring(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return modelName;
    }
}

