/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.data.bean;

import cn.com.voltronic.solar.data.bean.ConfigData;
import java.util.Calendar;
import java.util.Date;

public class ModelPlanBean {
    private static int HYBRID_BASIC = 50;
    private static int GRIDTIE_BASIC = 100;
    private static int OFFGRID_BASIC = 150;
    private static int VEXTEX_BASIX = 151;
    private static int HOMESOLAR_BASIC = 200;
    private String modeltype;
    private int ruleindex;
    private int planindex;
    private int check_charge;
    private int check_accharge;
    private int check_pvfeedgrid;
    private int check_batdispvon;
    private int check_batdispvloss;
    private int check_batfeedpvon;
    private int check_batfeedpvloss;
    private int check_acchargelimit;
    private int check_smarkMeterCharging;
    private int check_gridChargingLowestBatVol;
    private double acchargelimit;
    private double maxacchargelimit;
    private double minacchargelimit;
    private int acctParams = 2;
    private String acChargingStarttime;
    private String acChargingEndtime;
    private String acChargingStarttime2;
    private String acChargingEndtime2;
    private String acoutputStarttime;
    private String acoutputEndtime;
    private double gridChargingLowestBatVol;
    private int nominalVIndex;
    private int nominalFIndex;
    private double cutoffVoltage;
    private double floatingVoltage;

    public Date stringToTime(String strTime) {
        if (strTime != null && strTime.length() == 4) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, Integer.parseInt(strTime.substring(0, 2)));
            calendar.set(12, Integer.parseInt(strTime.substring(2, 4)));
            return calendar.getTime();
        }
        return new Date(0L);
    }

    public String timeToString(Date time) {
        Calendar date = Calendar.getInstance();
        date.setTime(time);
        return String.format("%02d%02d", date.get(11), date.get(12));
    }

    public String getModeltype() {
        return this.modeltype;
    }

    public void setModeltype(String modeltype) {
        this.modeltype = modeltype;
    }

    public int getRuleindex() {
        return this.ruleindex;
    }

    public void setRuleindex(int ruleindex) {
        this.ruleindex = ruleindex;
    }

    public int getPlanindex() {
        return this.planindex;
    }

    public void setPlanindex(int planindex) {
        this.planindex = planindex;
    }

    public int getCheck_charge() {
        return this.check_charge;
    }

    public void setCheck_charge(int check_charge) {
        this.check_charge = check_charge;
    }

    public int getCheck_accharge() {
        return this.check_accharge;
    }

    public void setCheck_accharge(int check_accharge) {
        this.check_accharge = check_accharge;
    }

    public int getCheck_pvfeedgrid() {
        return this.check_pvfeedgrid;
    }

    public void setCheck_pvfeedgrid(int check_pvfeedgrid) {
        this.check_pvfeedgrid = check_pvfeedgrid;
    }

    public int getCheck_batdispvon() {
        return this.check_batdispvon;
    }

    public void setCheck_batdispvon(int check_batdispvon) {
        this.check_batdispvon = check_batdispvon;
    }

    public int getCheck_batdispvloss() {
        return this.check_batdispvloss;
    }

    public void setCheck_batdispvloss(int check_batdispvloss) {
        this.check_batdispvloss = check_batdispvloss;
    }

    public int getCheck_batfeedpvon() {
        return this.check_batfeedpvon;
    }

    public void setCheck_batfeedpvon(int check_batfeedpvon) {
        this.check_batfeedpvon = check_batfeedpvon;
    }

    public int getCheck_batfeedpvloss() {
        return this.check_batfeedpvloss;
    }

    public void setCheck_batfeedpvloss(int check_batfeedpvloss) {
        this.check_batfeedpvloss = check_batfeedpvloss;
    }

    public int getCheck_acchargelimit() {
        return this.check_acchargelimit;
    }

    public void setCheck_acchargelimit(int check_acchargelimit) {
        this.check_acchargelimit = check_acchargelimit;
    }

    public double getAcchargelimit() {
        if (this.check_acchargelimit == 1) {
            return this.acchargelimit;
        }
        return 0.0;
    }

    public void setAcchargelimit(double acchargelimit) {
        this.acchargelimit = acchargelimit;
    }

    public String getAcChargingStarttime() {
        return this.acChargingStarttime;
    }

    public Date getAcChargingStarttimeFormat() {
        return this.stringToTime(this.acChargingStarttime);
    }

    public String getAcChargingStarttime2() {
        return this.acChargingStarttime2;
    }

    public Date getAcChargingStarttimeFormat2() {
        return this.stringToTime(this.acChargingStarttime2);
    }

    public void setAcChargingStarttime(String acChargingStarttime) {
        this.acChargingStarttime = acChargingStarttime;
    }

    public void setAcChargingStarttime(Date time) {
        this.acChargingStarttime = this.timeToString(time);
    }

    public void setAcChargingStarttime2(String acChargingStarttime2) {
        this.acChargingStarttime2 = acChargingStarttime2;
    }

    public void setAcChargingStarttime2(Date time) {
        this.acChargingStarttime2 = this.timeToString(time);
    }

    public String getAcChargingEndtime() {
        return this.acChargingEndtime;
    }

    public Date getAcChargingEndtimeFormat() {
        return this.stringToTime(this.acChargingEndtime);
    }

    public String getAcChargingEndtime2() {
        return this.acChargingEndtime2;
    }

    public Date getAcChargingEndtimeFormat2() {
        return this.stringToTime(this.acChargingEndtime2);
    }

    public void setAcChargingEndtime(String acChargingEndtime) {
        this.acChargingEndtime = acChargingEndtime;
    }

    public void setAcChargingEndtime(Date time) {
        this.acChargingEndtime = this.timeToString(time);
    }

    public void setAcChargingEndtime2(String acChargingEndtime2) {
        this.acChargingEndtime2 = acChargingEndtime2;
    }

    public void setAcChargingEndtime2(Date time) {
        this.acChargingEndtime2 = this.timeToString(time);
    }

    public String getAcoutputStarttime() {
        return this.acoutputStarttime;
    }

    public Date getAcoutputStarttimeFormat() {
        return this.stringToTime(this.acoutputStarttime);
    }

    public void setAcoutputStarttime(String acoutputStarttime) {
        this.acoutputStarttime = acoutputStarttime;
    }

    public void setAcoutputStarttime(Date time) {
        this.acoutputStarttime = this.timeToString(time);
    }

    public String getAcoutputEndtime() {
        return this.acoutputEndtime;
    }

    public Date getAcoutputEndtimeFormat() {
        return this.stringToTime(this.acoutputEndtime);
    }

    public void setAcoutputEndtime(String acoutputEndtime) {
        this.acoutputEndtime = acoutputEndtime;
    }

    public void setAcoutputEndtime(Date time) {
        this.acoutputEndtime = this.timeToString(time);
    }

    public double getFloatingVoltage() {
        return this.floatingVoltage;
    }

    public void setFloatingVoltage(double floatingVoltage) {
        this.floatingVoltage = floatingVoltage;
    }

    public void readFromConfigData(ConfigData config) {
        int modeid = 0;
        try {
            modeid = Integer.parseInt(config.getModelID());
            if (modeid >= HOMESOLAR_BASIC) {
                this.modeltype = "11";
                this.ruleindex = this.getNewRuleIndexfromBasic(modeid - HOMESOLAR_BASIC);
            } else if (modeid == VEXTEX_BASIX) {
                this.modeltype = "01";
                this.ruleindex = 0;
            } else if (modeid == OFFGRID_BASIC) {
                this.modeltype = "01";
                this.ruleindex = 0;
            } else if (modeid >= GRIDTIE_BASIC) {
                this.modeltype = "00";
                this.ruleindex = this.getNewRuleIndexfromBasic(modeid - GRIDTIE_BASIC);
            } else {
                this.modeltype = "10";
                this.ruleindex = this.getNewRuleIndexfromBasic(modeid - HYBRID_BASIC);
            }
            if (this.modeltype.equalsIgnoreCase("10")) {
                this.planindex = Integer.parseInt(config.getPlanID());
                if (this.planindex > 0 && this.planindex != 4) {
                    --this.planindex;
                }
            } else if (this.modeltype.equalsIgnoreCase("11")) {
                this.planindex = 3;
            } else if (this.modeltype.equalsIgnoreCase("01")) {
                this.planindex = Integer.parseInt(config.getPlanID());
                if (this.planindex == 2) {
                    this.planindex = modeid == VEXTEX_BASIX ? 2 : 0;
                } else if (this.planindex == 1) {
                    this.planindex = 1;
                }
            } else {
                this.planindex = 0;
            }
            this.check_charge = config.getCheck_charge();
            this.check_accharge = config.getCheck_accharge();
            this.check_pvfeedgrid = config.getCheck_pvfeedgrid();
            this.check_batdispvon = config.getCheck_batdispvon();
            this.check_batdispvloss = config.getCheck_batdispvloss();
            this.check_batfeedpvon = config.getCheck_batfeedpvon();
            this.check_batfeedpvloss = config.getCheck_batfeedpvloss();
            this.check_smarkMeterCharging = config.getCheck_smarkMeterCharging();
            this.check_gridChargingLowestBatVol = config.getCheck_gridChargingLowestBatVol();
            this.acchargelimit = config.getAcChargingLimit();
            this.check_acchargelimit = config.getAcChargingLimit() == 0.0 ? 0 : 1;
            this.acChargingStarttime = config.getAcChargeStarttime();
            this.acChargingEndtime = config.getAcChargeEndtime();
            this.acoutputStarttime = config.getAcoutputStarttime();
            this.acoutputEndtime = config.getAcoutputEndtime();
            this.maxacchargelimit = config.getFloatingVoltage();
            this.minacchargelimit = config.getCutoffVoltageGridLoss();
            this.gridChargingLowestBatVol = config.getGridChargingLowestBatVol();
            this.cutoffVoltage = config.getCutoffVoltage();
            this.floatingVoltage = config.getFloatingVoltage();
            switch ((int)config.getNominalVoltage()) {
                case 240: {
                    this.nominalVIndex = 0;
                    break;
                }
                case 230: {
                    this.nominalVIndex = 1;
                    break;
                }
                case 220: {
                    this.nominalVIndex = 2;
                    break;
                }
                case 208: {
                    this.nominalVIndex = 3;
                    break;
                }
                case 202: {
                    this.nominalVIndex = 4;
                    break;
                }
                case 127: {
                    this.nominalVIndex = 5;
                    break;
                }
                case 120: {
                    this.nominalVIndex = 6;
                    break;
                }
                case 110: {
                    this.nominalVIndex = 7;
                    break;
                }
                case 101: {
                    this.nominalVIndex = 8;
                }
            }
            this.nominalFIndex = (int)config.getNominalFreq() == 50 ? 0 : 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readFromConfigDataP17(ConfigData config) {
        int modeid = 0;
        try {
            modeid = Integer.parseInt(config.getModelID());
            if (modeid == VEXTEX_BASIX) {
                this.modeltype = "01";
                this.ruleindex = 0;
            } else if (modeid == OFFGRID_BASIC) {
                this.modeltype = "01";
                this.ruleindex = 0;
            } else if (modeid >= GRIDTIE_BASIC) {
                this.modeltype = "00";
                this.ruleindex = modeid - GRIDTIE_BASIC;
            } else {
                this.modeltype = "10";
                this.ruleindex = modeid - HYBRID_BASIC;
            }
            this.planindex = this.modeltype.equalsIgnoreCase("10") ? Integer.parseInt(config.getPlanID()) : (this.modeltype.equalsIgnoreCase("01") ? Integer.parseInt(config.getPlanID()) : 0);
            this.check_charge = config.getCheck_charge();
            this.check_accharge = config.getCheck_accharge();
            this.check_pvfeedgrid = config.getCheck_pvfeedgrid();
            this.check_batdispvon = config.getCheck_batdispvon();
            this.check_batdispvloss = config.getCheck_batdispvloss();
            this.check_batfeedpvon = config.getCheck_batfeedpvon();
            this.check_batfeedpvloss = config.getCheck_batfeedpvloss();
            this.check_gridChargingLowestBatVol = config.getCheck_gridChargingLowestBatVol();
            this.acchargelimit = config.getAcChargingLimit();
            this.check_acchargelimit = config.getAcChargingLimit() == 0.0 ? 0 : 1;
            this.acctParams = config.getAcctParams();
            this.acChargingStarttime = config.getAcChargeStarttime();
            this.acChargingEndtime = config.getAcChargeEndtime();
            this.acChargingStarttime2 = config.getAcChargeStarttime2();
            this.acChargingEndtime2 = config.getAcChargeEndtime2();
            this.acoutputStarttime = config.getAcoutputStarttime();
            this.acoutputEndtime = config.getAcoutputEndtime();
            this.maxacchargelimit = config.getFloatingVoltage();
            this.minacchargelimit = config.getCutoffVoltageGridLoss();
            this.gridChargingLowestBatVol = config.getGridChargingLowestBatVol();
            this.floatingVoltage = config.getFloatingVoltage();
            switch ((int)config.getNominalVoltage()) {
                case 240: {
                    this.nominalVIndex = 0;
                    break;
                }
                case 230: {
                    this.nominalVIndex = 1;
                    break;
                }
                case 220: {
                    this.nominalVIndex = 2;
                    break;
                }
                case 208: {
                    this.nominalVIndex = 3;
                    break;
                }
                case 202: {
                    this.nominalVIndex = 4;
                    break;
                }
                case 127: {
                    this.nominalVIndex = 5;
                    break;
                }
                case 120: {
                    this.nominalVIndex = 6;
                    break;
                }
                case 110: {
                    this.nominalVIndex = 7;
                    break;
                }
                case 101: {
                    this.nominalVIndex = 8;
                }
            }
            this.nominalFIndex = (int)config.getNominalFreq() == 50 ? 0 : 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getModelID() {
        int id = 50;
        id = this.modeltype.equalsIgnoreCase("10") ? 50 + this.getModeindexfromRuleindex(this.getRuleindex()) : (this.modeltype.equalsIgnoreCase("00") ? 100 + this.getModeindexfromRuleindex(this.getRuleindex()) : (this.modeltype.equalsIgnoreCase("01") ? (this.getPlanindex() == 2 ? 151 : 150) : 200 + this.getModeindexfromRuleindex(this.getRuleindex())));
        return String.format("%03d", id);
    }

    public String getP17ModelID() {
        int id = 50;
        id = this.modeltype.equalsIgnoreCase("10") ? 50 + this.getRuleindex() : (this.modeltype.equalsIgnoreCase("00") ? 100 + this.getRuleindex() : (this.modeltype.equalsIgnoreCase("01") ? (this.getPlanindex() == 2 ? 151 : 150) : 50 + this.getRuleindex()));
        return String.format("%03d", id);
    }

    private int getModeindexfromRuleindex(int ruleindex) {
        int[] nArray = new int[24];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 10;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 11;
        nArray[11] = 13;
        nArray[12] = 14;
        nArray[13] = 15;
        nArray[14] = 16;
        nArray[15] = 17;
        nArray[16] = 18;
        nArray[17] = 19;
        nArray[18] = 20;
        nArray[19] = 21;
        nArray[20] = 22;
        nArray[21] = 23;
        nArray[22] = 24;
        nArray[23] = 25;
        int[] rule = nArray;
        return rule[ruleindex];
    }

    private int getNewRuleIndexfromBasic(int oldindex) {
        if (oldindex == 10) {
            return 5;
        }
        if (oldindex >= 13) {
            return oldindex - 2;
        }
        if (oldindex > 10) {
            return oldindex - 1;
        }
        return oldindex;
    }

    public String getPlanID() {
        int id = 0;
        if (this.modeltype.equalsIgnoreCase("10")) {
            id = this.getPlanindex() == 4 ? this.getPlanindex() : this.getPlanindex() + 1;
        } else if (this.modeltype.equalsIgnoreCase("01")) {
            id = this.getPlanindex() == 0 ? 2 : (this.getPlanindex() == 1 ? 1 : 2);
        }
        return String.format("%02d", id);
    }

    public String getP17PlanID() {
        int id = this.getPlanindex();
        return String.format("%02d", id);
    }

    public int getChargingIndex() {
        if (this.modeltype.equalsIgnoreCase("00") || this.modeltype.equalsIgnoreCase("11")) {
            return 0;
        }
        if (this.check_charge == 0 && this.check_accharge == 0) {
            return 2;
        }
        if (this.check_accharge == 0) {
            return 1;
        }
        return 0;
    }

    public int getChargingIndex17(int planid) {
        if (this.modeltype.equalsIgnoreCase("00") || this.modeltype.equalsIgnoreCase("10") && planid == 3) {
            return 0;
        }
        if (this.check_charge == 0 && this.check_accharge == 0) {
            return 2;
        }
        if (this.check_accharge == 0) {
            return 1;
        }
        return 0;
    }

    public int getLoadPVonIndex() {
        if (this.modeltype.equalsIgnoreCase("10") ? (this.getPlanindex() == 1 || this.getPlanindex() == 2 || this.getPlanindex() == 4) && this.check_batdispvon == 0 : this.modeltype.equalsIgnoreCase("01") && this.getPlanindex() == 0 && this.check_batdispvon == 0) {
            return 1;
        }
        return 0;
    }

    public int getLoadPVLossIndex() {
        if (this.modeltype.equalsIgnoreCase("10")) {
            if (this.getPlanindex() == 0) {
                if (this.check_batdispvloss == 1) {
                    return 1;
                }
                return 0;
            }
            if (this.check_batdispvloss == 1) {
                return 0;
            }
            return 1;
        }
        if (this.modeltype.equalsIgnoreCase("01")) {
            if (this.getPlanindex() == 0) {
                if (this.check_batdispvloss == 1) {
                    return 0;
                }
                return 1;
            }
            if (this.check_batdispvloss == 0) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public double getMaxacchargelimit() {
        return this.maxacchargelimit;
    }

    public void setMaxacchargelimit(double maxacchargelimit) {
        this.maxacchargelimit = maxacchargelimit;
    }

    public double getMinacchargelimit() {
        return this.minacchargelimit;
    }

    public void setMinacchargelimit(double minacchargelimit) {
        this.minacchargelimit = minacchargelimit;
    }

    public int getNominalVIndex() {
        return this.nominalVIndex;
    }

    public void setNominalVIndex(int nominalVIndex) {
        this.nominalVIndex = nominalVIndex;
    }

    public int getNominalFIndex() {
        return this.nominalFIndex;
    }

    public void setNominalFIndex(int nominalFIndex) {
        this.nominalFIndex = nominalFIndex;
    }

    public double getNominalVoltage() {
        double[] temp = new double[]{240.0, 230.0, 220.0, 208.0, 202.0, 127.0, 120.0, 110.0, 101.0};
        return temp[this.nominalVIndex];
    }

    public double getP17NominalVoltage() {
        double[] temp = new double[]{240.0, 230.0, 220.0, 208.0, 202.0, 127.0, 120.0, 110.0, 101.0};
        return temp[this.nominalVIndex];
    }

    public double getNominalFreq() {
        if (this.nominalFIndex == 0) {
            return 50.0;
        }
        return 60.0;
    }

    public double getGridChargingLowestBatVol() {
        return this.gridChargingLowestBatVol;
    }

    public void setGridChargingLowestBatVol(double gridChargingLowestBatVol) {
        this.gridChargingLowestBatVol = gridChargingLowestBatVol;
    }

    public int getCheck_smarkMeterCharging() {
        return this.check_smarkMeterCharging;
    }

    public void setCheck_smarkMeterCharging(int check_smarkMeterCharging) {
        this.check_smarkMeterCharging = check_smarkMeterCharging;
    }

    public int getCheck_gridChargingLowestBatVol() {
        return this.check_gridChargingLowestBatVol;
    }

    public void setCheck_gridChargingLowestBatVol(int check_gridChargingLowestBatVol) {
        this.check_gridChargingLowestBatVol = check_gridChargingLowestBatVol;
    }

    public double getCutoffVoltage() {
        return this.cutoffVoltage;
    }

    public void setCutoffVoltage(double cutoffVoltage) {
        this.cutoffVoltage = cutoffVoltage;
    }

    public int getAcctParams() {
        return this.acctParams;
    }

    public void setAcctParams(int acctParams) {
        this.acctParams = acctParams;
    }
}

