/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.BridgeMethodResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationUtils {
    public static Annotation[] getAnnotations(Method method) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotation(clazz);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException(clazz + " is not an annotation");
        }
        A a = AnnotationUtils.getAnnotation(method, clazz);
        Class<?> clazz2 = method.getDeclaringClass();
        while (a == null && (clazz2 = clazz2.getSuperclass()) != null && !clazz2.equals(Object.class)) {
            try {
                method = clazz2.getDeclaredMethod(method.getName(), method.getParameterTypes());
                a = AnnotationUtils.getAnnotation(method, clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return a;
    }
}

