/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclEntryImpl
implements AclEntry,
Serializable {
    private static final long serialVersionUID = -5047185131260073216L;
    private Principal princ = null;
    private boolean neg = false;
    private Vector<Permission> permList = null;
    private Vector<String> commList = null;

    private AclEntryImpl(AclEntryImpl aclEntryImpl) throws UnknownHostException {
        this.setPrincipal(aclEntryImpl.getPrincipal());
        this.permList = new Vector();
        this.commList = new Vector();
        Enumeration<Object> enumeration = aclEntryImpl.communities();
        while (enumeration.hasMoreElements()) {
            this.addCommunity(enumeration.nextElement());
        }
        enumeration = aclEntryImpl.permissions();
        while (enumeration.hasMoreElements()) {
            this.addPermission((Permission)enumeration.nextElement());
        }
        if (aclEntryImpl.isNegative()) {
            this.setNegativePermissions();
        }
    }

    public AclEntryImpl() {
        this.princ = null;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public AclEntryImpl(Principal principal) throws UnknownHostException {
        this.princ = principal;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    @Override
    public Object clone() {
        AclEntryImpl aclEntryImpl;
        try {
            aclEntryImpl = new AclEntryImpl(this);
        }
        catch (UnknownHostException unknownHostException) {
            aclEntryImpl = null;
        }
        return aclEntryImpl;
    }

    @Override
    public boolean isNegative() {
        return this.neg;
    }

    @Override
    public boolean addPermission(Permission permission) {
        if (this.permList.contains(permission)) {
            return false;
        }
        this.permList.addElement(permission);
        return true;
    }

    @Override
    public boolean removePermission(Permission permission) {
        if (!this.permList.contains(permission)) {
            return false;
        }
        this.permList.removeElement(permission);
        return true;
    }

    @Override
    public boolean checkPermission(Permission permission) {
        return this.permList.contains(permission);
    }

    @Override
    public Enumeration<Permission> permissions() {
        return this.permList.elements();
    }

    @Override
    public void setNegativePermissions() {
        this.neg = true;
    }

    @Override
    public Principal getPrincipal() {
        return this.princ;
    }

    @Override
    public boolean setPrincipal(Principal principal) {
        if (this.princ != null) {
            return false;
        }
        this.princ = principal;
        return true;
    }

    @Override
    public String toString() {
        return "AclEntry:" + this.princ.toString();
    }

    public Enumeration<String> communities() {
        return this.commList.elements();
    }

    public boolean addCommunity(String string) {
        if (this.commList.contains(string)) {
            return false;
        }
        this.commList.addElement(string);
        return true;
    }

    public boolean removeCommunity(String string) {
        if (!this.commList.contains(string)) {
            return false;
        }
        this.commList.removeElement(string);
        return true;
    }

    public boolean checkCommunity(String string) {
        return this.commList.contains(string);
    }
}

