/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.internal.SnmpTools;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SnmpEngineId
implements Serializable {
    private static final long serialVersionUID = 5434729655830763317L;
    byte[] engineId = null;
    String hexString = null;
    String humanString = null;

    SnmpEngineId(String string) {
        this.engineId = SnmpTools.ascii2binary(string);
        this.hexString = string.toLowerCase();
    }

    SnmpEngineId(byte[] byArray) {
        this.engineId = byArray;
        this.hexString = SnmpTools.binary2ascii(byArray).toLowerCase();
    }

    public String getReadableId() {
        return this.humanString;
    }

    public String toString() {
        return this.hexString;
    }

    public byte[] getBytes() {
        return this.engineId;
    }

    void setStringValue(String string) {
        this.humanString = string;
    }

    static void validateId(String string) throws IllegalArgumentException {
        byte[] byArray = SnmpTools.ascii2binary(string);
        SnmpEngineId.validateId(byArray);
    }

    static void validateId(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length < 5) {
            throw new IllegalArgumentException("Id size lower than 5 bytes.");
        }
        if (byArray.length > 32) {
            throw new IllegalArgumentException("Id size greater than 32 bytes.");
        }
        if ((byArray[0] & 0x80) == 0 && byArray.length != 12) {
            throw new IllegalArgumentException("Very first bit = 0 and length != 12 octets");
        }
        byte[] byArray2 = new byte[byArray.length];
        if (Arrays.equals(byArray2, byArray)) {
            throw new IllegalArgumentException("Zeroed Id.");
        }
        byte[] byArray3 = new byte[byArray.length];
        Arrays.fill(byArray3, (byte)-1);
        if (Arrays.equals(byArray3, byArray)) {
            throw new IllegalArgumentException("0xFF Id.");
        }
    }

    public static SnmpEngineId createEngineId(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        SnmpEngineId.validateId(byArray);
        return new SnmpEngineId(byArray);
    }

    public static SnmpEngineId createEngineId() {
        Object var0 = null;
        byte[] byArray = new byte[13];
        int n = 42;
        long l = 255L;
        long l2 = System.currentTimeMillis();
        byArray[0] = (byte)((n & 0xFF000000) >> 24);
        byArray[0] = (byte)(byArray[0] | 0x80);
        byArray[1] = (byte)((n & 0xFF0000) >> 16);
        byArray[2] = (byte)((n & 0xFF00) >> 8);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = 5;
        byArray[5] = (byte)((l2 & l << 56) >>> 56);
        byArray[6] = (byte)((l2 & l << 48) >>> 48);
        byArray[7] = (byte)((l2 & l << 40) >>> 40);
        byArray[8] = (byte)((l2 & l << 32) >>> 32);
        byArray[9] = (byte)((l2 & l << 24) >>> 24);
        byArray[10] = (byte)((l2 & l << 16) >>> 16);
        byArray[11] = (byte)((l2 & l << 8) >>> 8);
        byArray[12] = (byte)(l2 & l);
        return new SnmpEngineId(byArray);
    }

    public SnmpOid toOid() {
        long[] lArray = new long[this.engineId.length + 1];
        lArray[0] = this.engineId.length;
        for (int i = 1; i <= this.engineId.length; ++i) {
            lArray[i] = this.engineId[i - 1] & 0xFF;
        }
        return new SnmpOid(lArray);
    }

    public static SnmpEngineId createEngineId(String string) throws IllegalArgumentException, UnknownHostException {
        return SnmpEngineId.createEngineId(string, null);
    }

    public static SnmpEngineId createEngineId(String string, String string2) throws IllegalArgumentException, UnknownHostException {
        if (string == null) {
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            SnmpEngineId.validateId(string);
            return new SnmpEngineId(string);
        }
        string2 = string2 == null ? ":" : string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 161;
        int n2 = 42;
        InetAddress inetAddress = null;
        SnmpEngineId snmpEngineId = null;
        try {
            try {
                string3 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException("Passed string is invalid : [" + string + "]");
            }
            if (!string3.equals(string2)) {
                inetAddress = InetAddress.getByName(string3);
                try {
                    stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
                    snmpEngineId.setStringValue(string);
                    return snmpEngineId;
                }
            } else {
                inetAddress = InetAddress.getLocalHost();
            }
            try {
                string4 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
                snmpEngineId.setStringValue(string);
                return snmpEngineId;
            }
            if (!string4.equals(string2)) {
                n = Integer.parseInt(string4);
                try {
                    stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
                    snmpEngineId.setStringValue(string);
                    return snmpEngineId;
                }
            }
            try {
                string5 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
                snmpEngineId.setStringValue(string);
                return snmpEngineId;
            }
            if (!string5.equals(string2)) {
                n2 = Integer.parseInt(string5);
            }
            snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
            snmpEngineId.setStringValue(string);
            return snmpEngineId;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Passed string is invalid : [" + string + "]. Check that the used separator [" + string2 + "] is compatible with IPv6 address format.");
        }
    }

    public static SnmpEngineId createEngineId(int n) throws UnknownHostException {
        int n2 = 42;
        InetAddress inetAddress = null;
        inetAddress = InetAddress.getLocalHost();
        return SnmpEngineId.createEngineId(inetAddress, n, n2);
    }

    public static SnmpEngineId createEngineId(InetAddress inetAddress, int n) throws IllegalArgumentException {
        int n2 = 42;
        if (inetAddress == null) {
            throw new IllegalArgumentException("InetAddress is null.");
        }
        return SnmpEngineId.createEngineId(inetAddress, n, n2);
    }

    public static SnmpEngineId createEngineId(int n, int n2) throws UnknownHostException {
        InetAddress inetAddress = null;
        inetAddress = InetAddress.getLocalHost();
        return SnmpEngineId.createEngineId(inetAddress, n, n2);
    }

    public static SnmpEngineId createEngineId(InetAddress inetAddress, int n, int n2) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("InetAddress is null.");
        }
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[9 + byArray.length];
        byArray2[0] = (byte)((n2 & 0xFF000000) >> 24);
        byArray2[0] = (byte)(byArray2[0] | 0x80);
        byArray2[1] = (byte)((n2 & 0xFF0000) >> 16);
        byArray2[2] = (byte)((n2 & 0xFF00) >> 8);
        byArray2[3] = (byte)(n2 & 0xFF);
        byArray2[4] = 5;
        if (byArray.length == 4) {
            byArray2[4] = 1;
        }
        if (byArray.length == 16) {
            byArray2[4] = 2;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 5] = byArray[i];
        }
        byArray2[5 + byArray.length] = (byte)((n & 0xFF000000) >> 24);
        byArray2[6 + byArray.length] = (byte)((n & 0xFF0000) >> 16);
        byArray2[7 + byArray.length] = (byte)((n & 0xFF00) >> 8);
        byArray2[8 + byArray.length] = (byte)(n & 0xFF);
        return new SnmpEngineId(byArray2);
    }

    public static SnmpEngineId createEngineId(int n, InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("InetAddress is null.");
        }
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = (byte)((n & 0xFF000000) >> 24);
        byArray2[0] = (byte)(byArray2[0] | 0x80);
        byArray2[1] = (byte)((n & 0xFF0000) >> 16);
        byArray2[2] = (byte)((n & 0xFF00) >> 8);
        byArray2[3] = (byte)(n & 0xFF);
        if (byArray.length == 4) {
            byArray2[4] = 1;
        }
        if (byArray.length == 16) {
            byArray2[4] = 2;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 5] = byArray[i];
        }
        return new SnmpEngineId(byArray2);
    }

    public static SnmpEngineId createEngineId(InetAddress inetAddress) {
        return SnmpEngineId.createEngineId(42, inetAddress);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpEngineId)) {
            return false;
        }
        return this.hexString.equals(((SnmpEngineId)object).toString());
    }

    public int hashCode() {
        return this.hexString.hashCode();
    }
}

