/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.CommandParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.ControlRelation;
import cn.com.voltronic.solar.data.bean.EnableSpinnerParameter;
import cn.com.voltronic.solar.handler.ParameterActionHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P16;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.Clock;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.PageUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.MainJFrame;
import cn.com.voltronic.solar.view.QueryParameterThread;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.ComponentFactory;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParameterJDialog
extends AADialog {
    private static final long serialVersionUID = 3827137705369649804L;
    private AAButton cancelButton;
    private JPanel centerPanel;
    private AALabel dateLabel;
    private JLabel dateLabelPanel;
    private JTextField dateTextField;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel1;
    private JPanel jPanelc;
    private JPanel jPanela;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel lastPanel;
    private AAButton setDateButton;
    private JTextField timeTextField;
    private JLabel warningLabelC;
    private AALabel warningLabelV;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSpinner spLiminChargingCurrent;
    private JSpinner spLiContinueMin;
    private JSpinner spLiRechargVoltage;
    private AAButton jButton1;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel3;
    private AALabel jLabel4;
    private AALabel jLabel5;
    private AALabel jLabel6;
    private AALabel jLabel7;
    public ConfigData configData = null;
    public Capability cappbility = null;
    private AbstractProcessor processor = null;
    private IProtocol protocol = null;
    private Clock clock = null;
    private double step;
    private Point offset = new Point();
    private JWindow window = new JWindow();

    public ParameterJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.doDrag();
        this.configData = new ConfigData();
        this.cappbility = new Capability();
        SolarPowerTray.loginasFactory = false;
        this.protocol = new P16();
        try {
            this.processor = GlobalProcessors.getCurrentProcessor();
            if (this.processor != null) {
                this.protocol = this.processor.getProtocol();
                this.configData = (ConfigData)this.processor.getBeanBag().getBean("configdata");
                this.cappbility = (Capability)this.processor.getBeanBag().getBean("capability");
                this.configData.setCurrentKey("SELF");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocol == null) {
            this.protocol = new P16();
        }
        this.initComponents();
        this.setTitle("message.parametersSetting");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public String getString2byte(String str) {
        if (str != null && !"".equals(str)) {
            while (str.length() < 2) {
                str = "0" + str;
            }
            return str;
        }
        return "00";
    }

    private void setRelaCmdandControl(String command, int index, JComponent control, int decimal) {
        this.protocol.getCommandMap().setControl(command, index, control, decimal);
        String controlname = VolUtil.commandAndParaIndex(command, index);
        if (this.protocol.getRelationList() != null) {
            for (ControlRelation relaItem : this.protocol.getRelationList()) {
                if (relaItem.getRelacommandAndIndex().equalsIgnoreCase(controlname)) {
                    relaItem.setRelationControl(control);
                    continue;
                }
                if (!relaItem.getCommandAndIndex().equalsIgnoreCase(controlname)) continue;
                relaItem.setMainControl(control);
            }
        }
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanelc = new JPanel();
        this.jPanela = new JPanel();
        this.jPanel20 = new JPanel();
        this.jPanel21 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new AALabel();
        this.jLabel2 = new AALabel();
        this.jLabel3 = new AALabel();
        this.jLabel4 = new AALabel();
        this.jLabel5 = new AALabel();
        this.jLabel6 = new AALabel();
        this.jLabel7 = new AALabel();
        this.jButton1 = new AAButton();
        this.jButton1.setName("setLiBatterySetting");
        this.warningLabelV = new AALabel();
        this.warningLabelC = new JLabel();
        this.dateLabel = new AALabel();
        this.dateTextField = new JTextField();
        this.timeTextField = new JTextField();
        this.setDateButton = new AAButton();
        this.dateLabelPanel = new JLabel();
        this.lastPanel = new JPanel();
        this.cancelButton = new AAButton();
        this.jButton1.setEnabled(false);
        this.step = 0.1;
        this.spLiminChargingCurrent = ComponentFactory.createNumberSpinner(this.configData.getLiminFloatChargingCurrent(), this.configData.getLimaxFloatChargingCurrent(), this.step, this.configData.getLiFloatChargingCurrent());
        this.setRelaCmdandControl("setLiBatterySetting", 0, this.spLiminChargingCurrent, 1);
        this.spLiminChargingCurrent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ParameterJDialog.this.jButton1.setEnabled(true);
            }
        });
        this.spLiContinueMin = ComponentFactory.createNumberSpinner(this.configData.getLiminRemainingtime(), this.configData.getLimaxRemainingtime(), 1.0, this.configData.getLiRemainingtime());
        this.setRelaCmdandControl("setLiBatterySetting", 2, this.spLiContinueMin, 0);
        this.spLiContinueMin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ParameterJDialog.this.jButton1.setEnabled(true);
            }
        });
        this.spLiRechargVoltage = ComponentFactory.createNumberSpinner(this.configData.getLiminRecoverVoltage(), this.configData.getLimaxrecoverVoltage(), this.step, this.configData.getLiRecoverVoltage());
        this.setRelaCmdandControl("setLiBatterySetting", 1, this.spLiRechargVoltage, 1);
        this.spLiRechargVoltage.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ParameterJDialog.this.jButton1.setEnabled(true);
            }
        });
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
                if (currentProcessor != null) {
                    ParameterJDialog.this.jButton1.setEnabled(false);
                    if (ParameterJDialog.this.executeCommandLi()) {
                        DisplayMessage.showInfoDialog("message.setTrue");
                    } else {
                        DisplayMessage.showErrorDialog("message.setFalse");
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ParameterJDialog.this.closeWindows();
            }
        });
        this.jPanel20.setBorder(BorderFactory.createEtchedBorder());
        this.setJPanel20Layout();
        this.jPanel21.setBorder(BorderFactory.createEtchedBorder());
        this.setJPanel21Layout();
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.centerPanel.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.setJPanel1Layout();
        this.jPanelc.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelc.setLayout(new BorderLayout());
        this.jPanelc.add((Component)this.jPanel1, "Center");
        this.jPanelc.add((Component)this.jPanela, "Last");
        this.setJPanelaLayout();
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.jPanel20, "First");
        this.jPanel2.add((Component)this.jPanel21, "Last");
        this.warningLabelC.setIcon(new ImageIcon(Constants.WARNINGLIGHTIMG));
        this.warningLabelV.setText("message.noteMsgToUser");
        this.dateLabel.setText("message.machineTime[:]");
        this.dateTextField.setEditable(false);
        this.dateTextField.setBackground(I18NListener.bgColor);
        this.dateTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(ParameterJDialog.this.dateTextField);
                calendarPanel.setBounds(ParameterJDialog.this.getX() + ParameterJDialog.this.dateLabelPanel.getX() + 30, ParameterJDialog.this.getY() + ParameterJDialog.this.dateLabelPanel.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.dateLabelPanel.setIcon(new ImageIcon(Constants.DATE));
        this.dateLabelPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(ParameterJDialog.this.dateTextField);
                calendarPanel.setBounds(ParameterJDialog.this.getX() + ParameterJDialog.this.dateLabelPanel.getX() + 30, ParameterJDialog.this.getY() + ParameterJDialog.this.dateLabelPanel.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.timeTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ParameterJDialog.this.clock != null) {
                    ParameterJDialog.this.clock.setGo(false);
                }
            }
        });
        this.setDateButton.setText("message.apply");
        this.setDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                ParameterJDialog.this.setTime();
            }
        });
        if (!"P1730K".equals(this.processor.getProtocol().getProtocolID())) {
            this.jPanel4.setLayout(new BorderLayout());
            this.jLabel1.setText("message.libatterydesc");
            this.jLabel2.setText("               X:");
            this.jLabel3.setText("A");
            this.jLabel4.setText("               T:");
            this.jLabel5.setText("Min.");
            this.jLabel6.setText("               Y:");
            this.jLabel7.setText("V");
            this.jButton1.setText("message.apply");
        }
        this.setJPanel3Layout();
        if (!"P1730K".equals(this.processor.getProtocol().getProtocolID())) {
            this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
            this.setJPanel5Layout();
        }
        if (this.protocol.isSupportModelSetting()) {
            this.jPanel4.add((Component)this.jPanel5, "Center");
            this.jPanel4.add((Component)this.jPanel3, "South");
        } else {
            this.jPanel4.add((Component)this.jPanel3, "Center");
        }
        this.centerPanel.add((Component)this.jPanel2, "First");
        this.centerPanel.add((Component)this.jPanelc, "Center");
        this.centerPanel.add((Component)this.jPanel4, "Last");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.lastPanel.setBorder(BorderFactory.createEtchedBorder());
        this.cancelButton.setText("message.close");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterJDialog.this.closeWindows();
            }
        });
        GroupLayout lastPanelLayout = new GroupLayout(this.lastPanel);
        this.lastPanel.setLayout(lastPanelLayout);
        lastPanelLayout.setHorizontalGroup(lastPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, lastPanelLayout.createSequentialGroup().addContainerGap(613, Short.MAX_VALUE).addComponent(this.cancelButton).addContainerGap()));
        lastPanelLayout.setVerticalGroup(lastPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lastPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.lastPanel, "Last");
        this.getTime(false);
        this.pack();
    }

    public synchronized void closeWindows() {
        if (this.clock != null) {
            this.clock.setGo(false);
        }
        QueryParameterThread thread = new QueryParameterThread();
        thread.start();
        this.dispose();
    }

    private void setJPanel1Layout() {
        List<AutoRadioItem> list = this.protocol.getRadioParameter().getRadioParameterList();
        PageUtils.setRadioLayout(list, this.jPanel1, this);
    }

    private void setJPanel21Layout() {
        PageUtils.setSpinnerValueList(this.protocol.spinnerValueRelate());
        List<AutoSpinnerItem> list = this.protocol.getSpinnerParameter().getSpinnerParameterList();
        PageUtils.setSpinnerLayout(list, this.jPanel21, this, this.protocol.getCommandMap(), this.protocol.getRelationList(), true);
    }

    private void setJPanel20Layout() {
        List<AutoSpinnerItem> list = this.protocol.getFactoryParameter().getSpinnerParameterList();
        PageUtils.setSpinnerLayout(list, this.jPanel20, this, this.protocol.getCommandMap(), this.protocol.getRelationList(), false);
    }

    private void setJPanel3Layout() {
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(36, 36, 36).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateLabel, GroupLayout.Alignment.TRAILING).addComponent(this.warningLabelC, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.timeTextField).addComponent(this.dateTextField, -2, 126, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.setDateButton).addComponent(this.dateLabelPanel))).addComponent(this.warningLabelV, -1, 578, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.warningLabelV).addComponent(this.warningLabelC)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dateLabelPanel).addComponent(this.dateTextField, -2, -1, -2).addComponent(this.dateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.setDateButton).addComponent(this.timeTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void setJPanel5Layout() {
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel15Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spLiminChargingCurrent, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spLiContinueMin, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spLiRechargVoltage, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1))).addContainerGap(46, Short.MAX_VALUE)));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.spLiContinueMin, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jLabel2).addComponent(this.spLiminChargingCurrent, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.spLiRechargVoltage, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jButton1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void setJPanelaLayout() {
        EnableSpinnerParameter parameter = this.protocol.getEnableSpinnerParameter();
        if (parameter == null) {
            return;
        }
        List<JPanel> panels = PageUtils.createJPanelas(parameter, this);
        if (panels.isEmpty()) {
            return;
        }
        PageUtils.setEnableSpinnerLayout(panels, this.jPanela);
    }

    private void getTime(boolean isQuery) {
        Date date = new Date();
        if (this.processor != null) {
            Calendar ca = Calendar.getInstance();
            ca = isQuery ? this.processor.queryCurrentTime() : this.processor.getCurrentTime();
            if (ca != null) {
                date = ca.getTime();
            }
            this.dateTextField.setText(DateUtils.getFormatDate(date));
            this.clock = new Clock(date, this.timeTextField);
            this.clock.setGo(true);
            this.clock.start();
        } else {
            this.dateTextField.setText(DateUtils.getFormatDate(date));
            this.timeTextField.setText("");
        }
    }

    private boolean executeCommandLi() {
        boolean result = false;
        AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
        if (currentProcessor != null) {
            List<ControlRelation> relaList;
            String command = "setLiBatterySetting";
            CommandParameter para = currentProcessor.getProtocol().getCommandMap().getCommandParameter(command);
            if (para != null && (result = currentProcessor.executeControl(command, para.getValues())) && (relaList = currentProcessor.getProtocol().getRelationList()) != null && relaList.size() > 0) {
                int index = 0;
                while (index < para.getSize()) {
                    String command0 = VolUtil.commandAndParaIndex(command, index);
                    for (ControlRelation relaObj : relaList) {
                        SpinnerNumberModel model;
                        if (!relaObj.getCommandAndIndex().equalsIgnoreCase(command0)) continue;
                        double value = ParameterActionHandler.getValueFromMainControl(relaList, currentProcessor.getProtocol().getCommandMap(), relaObj.getRelacommandAndIndex(), relaObj.getRelationtype());
                        if (relaObj.getRelationtype() == ControlRelation.RELATION_MIN) {
                            model = (SpinnerNumberModel)((JSpinner)relaObj.getRelationControl()).getModel();
                            model.setMinimum(Double.valueOf(value));
                            if (!((Double)model.getValue() < value)) continue;
                            model.setValue(value);
                            continue;
                        }
                        if (relaObj.getRelationtype() != ControlRelation.RELATION_MAX) continue;
                        model = (SpinnerNumberModel)((JSpinner)relaObj.getRelationControl()).getModel();
                        model.setMaximum(Double.valueOf(value));
                        if (!((Double)model.getValue() > value)) continue;
                        model.setValue(value);
                    }
                    ++index;
                }
            }
        }
        return result;
    }

    private void setTime() {
        int re;
        if (this.processor == null) {
            this.processor = GlobalProcessors.getCurrentProcessor();
        }
        if (this.processor != null && (re = DisplayMessage.showConfirmDialog("message.noteMsgToUser", "message.confirm")) == 0) {
            boolean result = false;
            String source = this.dateTextField.getText().trim();
            String timeStr = this.timeTextField.getText().trim();
            if ("".equals(source) || "".equals(timeStr)) {
                result = false;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
            Calendar calendar = Calendar.getInstance();
            try {
                Date date = sdf.parse(source);
                calendar.setTime(date);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            String year = ("" + calendar.get(1)).substring(2);
            int mon = calendar.get(2) + 1;
            String month = "";
            month = mon < 10 ? "0" + mon : "" + mon;
            String day = "";
            int da = calendar.get(5);
            day = da < 10 ? "0" + da : "" + da;
            String time = "";
            String[] timeArr = timeStr.split(":");
            int i = 0;
            while (i < timeArr.length) {
                if (timeArr[i].length() < 2) {
                    timeArr[i] = "0" + timeArr[i];
                }
                time = String.valueOf(time) + timeArr[i];
                ++i;
            }
            if (source.length() == 10 && time.length() == 6) {
                StringBuffer parameter = new StringBuffer();
                parameter.append(year).append(month).append(day).append(time);
                try {
                    if (this.processor != null) {
                        result = this.processor.executeControl("setCurrentTime", new String[]{parameter.toString()});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                result = false;
            }
            if (result) {
                DisplayMessage.showInfoDialog("message.setTrue");
                this.getTime(true);
                if (this.processor != null) {
                    this.processor.setCurrentTime(this.processor.getCurrentTime());
                }
                MainJFrame.getNewInstance().refreshClock();
            } else {
                DisplayMessage.showErrorDialog("message.setFalse");
            }
        }
    }

    private void doDrag() {
        this.window.setVisible(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((ParameterJDialog)ParameterJDialog.this).offset.x = e.getXOnScreen();
                ((ParameterJDialog)ParameterJDialog.this).offset.y = e.getYOnScreen();
                ParameterJDialog.this.setBounds(ParameterJDialog.this.getX(), ParameterJDialog.this.getY(), ParameterJDialog.this.getWidth(), ParameterJDialog.this.getHeight());
                ParameterJDialog.this.window.setBounds(ParameterJDialog.this.getX(), ParameterJDialog.this.getY(), ParameterJDialog.this.getWidth(), ParameterJDialog.this.getHeight());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ParameterJDialog.this.setLocation(ParameterJDialog.this.window.getX(), ParameterJDialog.this.window.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = ParameterJDialog.this.window.getX() + e.getXOnScreen() - ((ParameterJDialog)ParameterJDialog.this).offset.x;
                int y = ParameterJDialog.this.window.getY() + e.getYOnScreen() - ((ParameterJDialog)ParameterJDialog.this).offset.y;
                ParameterJDialog.this.window.setLocation(x, y);
                ParameterJDialog.this.setLocation(x, y);
                ((ParameterJDialog)ParameterJDialog.this).offset.x = e.getXOnScreen();
                ((ParameterJDialog)ParameterJDialog.this).offset.y = e.getYOnScreen();
            }
        });
    }
}

