/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.DataFile;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParsingException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class WeakDataFile
extends WeakReference<DataFile> {
    private static final Logger LOGGER = Logger.getLogger(WeakDataFile.class.getName());
    private static final int MAX_ITERATIONS = 2;
    private static ReferenceQueue<DataFile> refQueue = new ReferenceQueue();
    private static List<WeakDataFile> refList = new ArrayList<WeakDataFile>();
    private final File file;
    private final RandomAccessFile raf;

    WeakDataFile(DataFile dataFile, File file) {
        super(dataFile, refQueue);
        refList.add(this);
        this.file = file;
        try {
            this.raf = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
        WeakDataFile.drainRefQueueBounded();
    }

    synchronized void read(long l, byte[] byArray, int n, int n2) {
        try {
            this.raf.seek(l);
            this.raf.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    synchronized long writeTo(long l, byte[] byArray, int n, int n2) {
        try {
            this.raf.seek(l);
            this.raf.write(byArray, n, n2);
            return this.raf.getFilePointer();
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    void close() {
        LOGGER.fine("Deleting file = " + this.file.getName());
        refList.remove(this);
        try {
            this.raf.close();
            this.file.delete();
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    void renameTo(File file) {
        LOGGER.fine("Moving file=" + this.file + " to=" + file);
        refList.remove(this);
        try {
            this.raf.close();
            this.file.renameTo(file);
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    static void drainRefQueueBounded() {
        WeakDataFile weakDataFile = (WeakDataFile)refQueue.poll();
        for (int i = 0; weakDataFile != null && i < 2; ++i) {
            LOGGER.fine("Cleaning file = " + weakDataFile.file + " from reference queue.");
            weakDataFile.close();
            weakDataFile = (WeakDataFile)refQueue.poll();
        }
    }
}

