/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.ModbusSlaveException;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.util.AtomicCounter;
import net.wimpi.modbus.util.Mutex;

public class ModbusSerialTransaction
implements ModbusTransaction {
    private static AtomicCounter c_TransactionID = new AtomicCounter(0);
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private int m_Retries = 3;
    private int m_TransDelayMS = 50;
    private SerialConnection m_SerialCon;
    private Mutex m_TransactionLock = new Mutex();
    private int currenttrytimes = 0;

    public int getCurrentTryTimes() {
        return this.currenttrytimes;
    }

    public ModbusSerialTransaction() {
    }

    public ModbusSerialTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusSerialTransaction(SerialConnection con) {
        this.setSerialConnection(con);
    }

    public void setSerialConnection(SerialConnection con) {
        this.m_SerialCon = con;
        this.m_IO = con.getModbusTransport();
    }

    @Override
    public int getTransactionID() {
        return c_TransactionID.get();
    }

    @Override
    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    @Override
    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    @Override
    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    @Override
    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    @Override
    public int getRetries() {
        return this.m_Retries;
    }

    @Override
    public void setRetries(int num) {
        this.m_Retries = num;
    }

    public int getTransDelayMS() {
        return this.m_TransDelayMS;
    }

    public void setTransDelayMS(int newTransDelayMS) {
        this.m_TransDelayMS = newTransDelayMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        try {
            try {
                this.m_TransactionLock.acquire();
                ModbusTransport modbusTransport = this.m_IO;
                synchronized (modbusTransport) {
                    this.currenttrytimes = 0;
                    boolean finished = false;
                    this.m_Request.setTransactionID(c_TransactionID.increment());
                    do {
                        try {
                            if (this.m_TransDelayMS > 0) {
                                try {
                                    Thread.sleep(this.m_TransDelayMS);
                                }
                                catch (InterruptedException ex) {
                                    System.err.println("InterruptedException: " + ex.getMessage());
                                }
                            }
                            this.m_IO.writeMessage(this.m_Request);
                            this.m_Response = this.m_IO.readResponse();
                            finished = true;
                        }
                        catch (ModbusIOException e) {
                            if (++this.currenttrytimes >= this.m_Retries) {
                                throw e;
                            }
                            System.err.println("execute try " + this.currenttrytimes + " error: " + e.getMessage());
                        }
                    } while (!finished);
                }
                if (this.m_Response instanceof ExceptionResponse) {
                    throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
                }
                if (this.isCheckingValidity()) {
                    this.checkValidity();
                }
            }
            catch (InterruptedException ex) {
                throw new ModbusIOException("Thread acquiring lock was interrupted.");
            }
        }
        finally {
            this.m_TransactionLock.release();
        }
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_SerialCon == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    protected void checkValidity() throws ModbusException {
    }
}

