/*
 * Decompiled with CFR 0.152.
 */
package javafx.util.converter;

import java.text.Format;
import java.text.ParseException;
import javafx.util.StringConverter;

public class FormatStringConverter<T>
extends StringConverter<T> {
    final Format format;

    public FormatStringConverter(Format format) {
        this.format = format;
    }

    @Override
    public T fromString(String string) {
        try {
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).length() < 1) {
                return null;
            }
            Format format = this.getFormat();
            return (T)format.parseObject(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    @Override
    public String toString(T t) {
        if (t == null) {
            return "";
        }
        Format format = this.getFormat();
        return format.format(t);
    }

    protected Format getFormat() {
        return this.format;
    }
}

