/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.data.bean;

import cn.com.voltronic.solar.util.VolUtil;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class CommandParameter {
    public static int DATA_DOUBLE = 0;
    public static int DATA_BOOL = 1;
    public static int DATA_STRING = 2;
    private String command;
    private int parasize;
    private int[] decimals;
    private JComponent[] controls;

    public CommandParameter(String command, int parasize) {
        this.command = command;
        this.parasize = parasize;
        this.controls = new JComponent[parasize];
        this.decimals = new int[parasize];
    }

    public String getCommand() {
        return this.command;
    }

    public void setParameter(int index, JComponent control, int decimal) {
        this.controls[index] = control;
        this.decimals[index] = decimal;
    }

    public JComponent getParameter(int index) {
        return this.controls[index];
    }

    public int getSize() {
        return this.parasize;
    }

    public Object[] getValues() {
        Object[] values = new Object[this.parasize];
        int index = 0;
        while (index < this.parasize) {
            values[index] = this.getValue(index);
            ++index;
        }
        return values;
    }

    public double getDoubleValue(JComponent control) {
        int index = 0;
        while (index < this.parasize) {
            if (this.controls[index].equals(control)) {
                return (Double)this.getValue(index);
            }
            ++index;
        }
        return 0.0;
    }

    private Object getValue(int index) {
        Object value = null;
        double dbvalue = 0.0;
        if (this.controls[index] instanceof JSpinner) {
            dbvalue = Double.parseDouble(((JSpinner)this.controls[index]).getValue().toString());
            value = VolUtil.round(dbvalue, this.decimals[index]);
        } else if (this.controls[index] instanceof JRadioButton) {
            value = ((JRadioButton)this.controls[index]).isSelected();
        } else if (this.controls[index] instanceof JTextField) {
            value = ((JTextField)this.controls[index]).getText();
        } else if (this.controls[index] instanceof JCheckBox) {
            value = ((JCheckBox)this.controls[index]).isSelected();
        } else if (this.controls[index] instanceof JComboBox) {
            value = ((JComboBox)this.controls[index]).getSelectedItem();
        }
        return value;
    }
}

