/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P17;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class P1730K
extends P17 {
    private String dspversion = "";
    private String mcuversion = "";

    @Override
    public String getProtocolID() {
        return "P1730K";
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.gridVoltager[:]", "{workInfo.getRGridVoltage}", "V"));
        item.add(new AutoLabelItem("message.gridVoltages[:]", "{workInfo.getSGridVoltage}", "V"));
        item.add(new AutoLabelItem("message.gridVoltaget[:]:", "{workInfo.getTGridVoltage}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            IComUSBHandler _handler = (IComUSBHandler)((Object)processor.getHandler());
            this.modelType = _handler.getModeType();
        }
        if (!this.modelType.equals("00")) {
            ConfigData configData;
            item.add(new AutoLabelItem("message.outputLoadPercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
            item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
            item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
            if (processor != null && (configData = (ConfigData)processor.getBeanBag().getBean("configdata")).getBatTptCompensate() > 0.0) {
                item.add(new AutoLabelItem("message.externalBatteryTemperature[:]", "{workInfo.getExternalBatteryTemperature}", "\u2103"));
            }
            item.add(new AutoLabelItem("message.acOutputActivePowerR[:]", "{workInfo.getAcOutputActivePowerR}", "W"));
            item.add(new AutoLabelItem("message.acOutputActivePowerS[:]", "{workInfo.getAcOutputActivePowerS}", "W"));
            item.add(new AutoLabelItem("message.acOutputActivePowerT[:]", "{workInfo.getAcOutputActivePowerT}", "W"));
            item.add(new AutoLabelItem("message.totalAcOutputActivePower[:]", "{workInfo.getWholeGridOutputPower}", "W"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerR[:]", "{workInfo.getAcOutputApperentPowerR}", "VA"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerS[:]", "{workInfo.getAcOutputApperentPowerS}", "VA"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerT[:]", "{workInfo.getAcOutputApperentPowerT}", "VA"));
            item.add(new AutoLabelItem("message.totalAcOutputApperentPower[:]", "{workInfo.getWholeGridOutputApperentPower}", "VA"));
        }
        item.add(new AutoLabelItem("message.innerTemperature[:]", "{workInfo.getInnerTemperature}", "\u2103"));
        item.add(new AutoLabelItem("message.maxComponentTemperature[:]", "{workInfo.getMaxTemperature}", "\u2103"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            IComUSBHandler _handler = (IComUSBHandler)handler;
            String dataStr = _handler.excuteSimpleCommand("PI");
            if (!StringUtils.isEmpty((String)dataStr) && dataStr.startsWith("17")) {
                block16: {
                    block15: {
                        String[] qmds;
                        block14: {
                            String qmdStr;
                            block13: {
                                qmdStr = _handler.excuteCommand("MD", true);
                                if (!StringUtils.isEmpty((String)qmdStr)) break block13;
                                return false;
                            }
                            qmds = qmdStr.split(",");
                            if (qmds.length >= 2) break block14;
                            return false;
                        }
                        int outputRateVA = VolUtil.parseInt(qmds[1]);
                        if (outputRateVA == 30000) break block15;
                        return false;
                    }
                    this.mpptTrackNumber = _handler.getMpptTrackNumber();
                    this.modelType = _handler.getModeType();
                    this.deviceModel = _handler.getDeviceModel();
                    String serialNoStr = _handler.getSerialNo();
                    if (!StringUtils.isEmpty((String)serialNoStr)) {
                        this.serialNo = serialNoStr;
                        break block16;
                    }
                    return false;
                }
                try {
                    dataStr = "";
                    int i = 0;
                    while (i < 5 && (StringUtils.isEmpty((String)dataStr) || dataStr.startsWith("(NAK") || dataStr.indexOf("MCU:") < 0 || dataStr.indexOf("DSP:") < 0)) {
                        dataStr = _handler.excuteSimpleCommand("VFWT");
                        String[] index = dataStr.split(",");
                        if (index.length > 0) {
                            this.dspversion = index[0];
                            this.mcuversion = index[1];
                        } else {
                            dataStr = "";
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                return true;
            }
            return false;
        }
        if (!(handler instanceof ModbusHandler)) {
            boolean cfr_ignored_0 = handler instanceof SNMPHandler;
        }
        return false;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.setPVIPLV[:]", "{configData.getMinPvInputLowV}", "{configData.getMaxPvInputLowV}", "1", "{configData.getPvInputLowV}", "V", "setPVIPLV", 0, false));
        list.add(new AutoSpinnerItem("message.setPVIPHV[:]", "{configData.getMinPvInputHighV}", "{configData.getMaxPvInputHighV}", "1", "{configData.getPvInputHighV}", "V", "setPVIPHV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTLV[:]", "{configData.getMinMpptLowV}", "{configData.getMaxMpptLowV}", "1", "{configData.getMpptLowV}", "V", "setMPPTLV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTHV[:]", "{configData.getMinMpptHighV}", "{configData.getMaxMpptHighV}", "1", "{configData.getMpptHighV}", "V", "setMPPTHV", 0, false));
        if (!this.modelType.equals("00")) {
            list.add(new AutoSpinnerItem("message.maxChargingCurrent[:]", "{configData.getMinMaxChargingCurrent}", "{configData.getMaxMaxChargingCurrent}", "0.1", "{configData.getMaxChargingCurrent}", "A", "setMaxChargingCurrent", 0, false));
            list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargingVoltage}", "{configData.getMaxMaxChargingVoltage}", "1", "{configData.getMaxChargingVoltage}", "V", "setMCHGV", 1, false));
            list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingVoltage}", "{configData.getMaxFloatingVoltage}", "1", "{configData.getFloatingVoltage}", "V", "setMCHGV", 0, false));
            list.add(new AutoSpinnerItem("message.cutoffVolGridOn[:]", "{configData.getMinCutoffVoltage}", "{configData.getMaxCutoffVoltage}", "1", "{configData.getCutoffVoltage}", "V", "setBatDischargeVol", 2, false));
            list.add(new AutoSpinnerItem("message.recoverVolGridOn[:]", "{configData.getMinRecoverVoltage}", "{configData.getMaxRecoverVoltage}", "1", "{configData.getRecoverVoltage}", "V", "setBatDischargeVol", 3, false));
            list.add(new AutoSpinnerItem("message.cutoffVolGridLoss[:]", "{configData.getMinCutoffVoltageGridLoss}", "{configData.getMaxCutoffVoltageGridLoss}", "1", "{configData.getCutoffVoltageGridLoss}", "V", "setBatDischargeVol", 0, false));
            list.add(new AutoSpinnerItem("message.recoverVolGridLoss[:]", "{configData.getMinRecoverVoltageGridLoss}", "{configData.getMaxRecoverVoltageGridLoss}", "1", "{configData.getRecoverVoltageGridLoss}", "V", "setBatDischargeVol", 1, false));
            list.add(new AutoSpinnerItem("message.batDischargeMaxCurrentInHybridMode[:]", "{configData.getMinBatDischargeMaxCurrentInHybridMode}", "{configData.getMaxBatDischargeMaxCurrentInHybridMode}", "1", "{configData.getBatDischargeMaxCurrentInHybridMode}", "A", "setBatDischargeMaxCurrentInHybridMode", 0, false));
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibrationR[:]", "{configData.getMinFeedingGridCalibrationPowerR}", "{configData.getMaxFeedingGridCalibrationPowerR}", "1", "{configData.getFeedingGridCalibrationPowerR}", "W", "setFeedingGridCalibrationPowerR", 0, false));
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibrationS[:]", "{configData.getMinFeedingGridCalibrationPowerS}", "{configData.getMaxFeedingGridCalibrationPowerS}", "1", "{configData.getFeedingGridCalibrationPowerS}", "W", "setFeedingGridCalibrationPowerS", 0, false));
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibrationT[:]", "{configData.getMinFeedingGridCalibrationPowerT}", "{configData.getMaxFeedingGridCalibrationPowerT}", "1", "{configData.getFeedingGridCalibrationPowerT}", "W", "setFeedingGridCalibrationPowerT", 0, false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.pepdP[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        if (!this.modelType.equals("01") && this.getMCUVersion().compareTo("170711123000") >= 0 && (this.deviceModel.equals("064") || this.deviceModel.equals("114") || this.deviceModel.equals("065") || this.deviceModel.equals("115") || this.deviceModel.equals("066") || this.deviceModel.equals("116") || this.deviceModel.equals("067") || this.deviceModel.equals("117") || this.deviceModel.equals("068") || this.deviceModel.equals("118") || this.deviceModel.equals("069") || this.deviceModel.equals("119"))) {
            list.add(new AutoRadioItem("message.OverFrequencyDerating[:]", "message.enable", "message.disable", "{cappbility.isCapableG}", "CapableG", false));
            list.add(new AutoRadioItem("message.OverVoltageDerating[:]", "message.enable", "message.disable", "{cappbility.isCapableH}", "CapableH", false));
            list.add(new AutoRadioItem("message.rPControl[:]", "message.enable", "message.disable", "{cappbility.getCheck_reactivePowerAutoControl}", "ENFH", false));
        }
        if (!this.modelType.equals("00")) {
            list.add(new AutoRadioItem("message.pepdB[:]", "message.enable", "message.disable", "{cappbility.isCapableC}", "CapableC", false));
            list.add(new AutoRadioItem("message.GNTM[:]", "message.enable", "message.disable", "{cappbility.isCapableD}", "CapableD", false));
            list.add(new AutoRadioItem("message.wideAcInputRange[:]", "message.enable", "message.disable", "{cappbility.isCapableE}", "CapableE", false));
            list.add(new AutoRadioItem("message.parallelforoutput[:]", "message.enable", "message.disable", "{cappbility.isParallelOutput}", "ParallelFO", false));
        }
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }
}

