/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.core.ControlFlow;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;

public abstract class ControlFlowFactory {
    public static ControlFlow createControlFlow() {
        return JdkVersion.isAtLeastJava14() ? new Jdk14ControlFlow() : new Jdk13ControlFlow();
    }

    static class Jdk13ControlFlow
    implements ControlFlow {
        private final String stackTrace;
        private final int stackTraceLength;

        public Jdk13ControlFlow() {
            StringWriter stringWriter = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(stringWriter));
            this.stackTrace = stringWriter.toString();
            this.stackTraceLength = this.stackTrace.length();
        }

        public boolean under(Class clazz) {
            Assert.notNull(clazz, "Class must not be null");
            return this.stackTrace.indexOf(clazz.getName()) != -1;
        }

        public boolean under(Class clazz, String string) {
            Assert.notNull(clazz, "Class must not be null");
            Assert.notNull(string, "Method name must not be null");
            String string2 = clazz.getName() + "." + string;
            int n = string2.length();
            int n2 = 0;
            do {
                if ((n2 = this.stackTrace.indexOf(string2, n2)) == -1) continue;
                int n3 = n2 + n;
                if (n3 == this.stackTraceLength) {
                    return true;
                }
                char c = this.stackTrace.charAt(n3);
                if (c == '(' || Character.isWhitespace(c)) {
                    return true;
                }
                n2 = n3;
            } while (n2 != -1);
            return false;
        }

        public boolean underToken(String string) {
            return string != null && this.stackTrace.indexOf(string) != -1;
        }
    }

    static class Jdk14ControlFlow
    implements ControlFlow {
        private StackTraceElement[] stack = new Throwable().getStackTrace();

        public boolean under(Class clazz) {
            Assert.notNull(clazz, "Class must not be null");
            String string = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean under(Class clazz, String string) {
            Assert.notNull(clazz, "Class must not be null");
            Assert.notNull(string, "Method name must not be null");
            String string2 = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(string2) || !this.stack[i].getMethodName().equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean underToken(String string) {
            if (string == null) {
                return false;
            }
            StringWriter stringWriter = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            return string2.indexOf(string) != -1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Jdk14ControlFlow: ");
            for (int i = 0; i < this.stack.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("\n\t@");
                }
                stringBuffer.append(this.stack[i]);
            }
            return stringBuffer.toString();
        }
    }
}

