/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.enums;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.core.enums.LabeledEnumResolver;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;

public abstract class AbstractCachingLabeledEnumResolver
implements LabeledEnumResolver {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private CachingMapDecorator labeledEnumCache = new CachingMapDecorator(){

        protected Object create(Object object) {
            Set set = AbstractCachingLabeledEnumResolver.this.findLabeledEnums((Class)object);
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("Unsupported labeled enumeration type '" + object + "': " + "make sure you've properly defined this enumeration: " + "if it's static, are the class and its fields public/static/final?");
            }
            HashMap<Comparable, LabeledEnum> hashMap = new HashMap<Comparable, LabeledEnum>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                LabeledEnum labeledEnum = (LabeledEnum)iterator.next();
                hashMap.put(labeledEnum.getCode(), labeledEnum);
            }
            return Collections.unmodifiableMap(hashMap);
        }
    };

    public Set getLabeledEnumSet(Class clazz) throws IllegalArgumentException {
        return new TreeSet(this.getLabeledEnumMap(clazz).values());
    }

    public Map getLabeledEnumMap(Class clazz) throws IllegalArgumentException {
        Assert.notNull(clazz, "No type specified");
        return (Map)this.labeledEnumCache.get(clazz);
    }

    public LabeledEnum getLabeledEnumByCode(Class clazz, Comparable comparable) throws IllegalArgumentException {
        Assert.notNull(comparable, "No enum code specified");
        Map map = this.getLabeledEnumMap(clazz);
        LabeledEnum labeledEnum = (LabeledEnum)map.get(comparable);
        if (labeledEnum == null) {
            throw new IllegalArgumentException("No enumeration with code '" + comparable + "'" + " of type [" + clazz.getName() + "] exists: this is likely a configuration error; " + "make sure the code value matches a valid instance's code property");
        }
        return labeledEnum;
    }

    public LabeledEnum getLabeledEnumByLabel(Class clazz, String string) throws IllegalArgumentException {
        Map map = this.getLabeledEnumMap(clazz);
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            LabeledEnum labeledEnum = (LabeledEnum)iterator.next();
            if (!labeledEnum.getLabel().equalsIgnoreCase(string)) continue;
            return labeledEnum;
        }
        throw new IllegalArgumentException("No enumeration with label '" + string + "' of type [" + clazz + "] exists: this is likely a configuration error; " + "make sure the label string matches a valid instance's label property");
    }

    protected abstract Set findLabeledEnums(Class var1);
}

