/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class ClassPathResource
extends AbstractResource {
    private final String path;
    private ClassLoader classLoader;
    private Class clazz;

    public ClassPathResource(String string) {
        this(string, (ClassLoader)null);
    }

    public ClassPathResource(String string, ClassLoader classLoader) {
        Assert.notNull(string, "Path must not be null");
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.path = StringUtils.cleanPath(string);
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassPathResource(String string, Class clazz) {
        Assert.notNull(string, "Path must not be null");
        this.path = StringUtils.cleanPath(string);
        this.clazz = clazz;
    }

    protected ClassPathResource(String string, ClassLoader classLoader, Class clazz) {
        this.path = string;
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        inputStream = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : this.classLoader.getResourceAsStream(this.path);
        if (inputStream == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return inputStream;
    }

    public URL getURL() throws IOException {
        URL uRL = null;
        uRL = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        if (uRL == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return uRL;
    }

    public File getFile() throws IOException {
        return ResourceUtils.getFile(this.getURL(), this.getDescription());
    }

    public Resource createRelative(String string) {
        String string2 = StringUtils.applyRelativePath(this.path, string);
        return new ClassPathResource(string2, this.classLoader, this.clazz);
    }

    public String getFilename() {
        return StringUtils.getFilename(this.path);
    }

    public String getDescription() {
        return "class path resource [" + this.path + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)object;
            return this.path.equals(classPathResource.path) && ObjectUtils.nullSafeEquals(this.classLoader, classPathResource.classLoader) && ObjectUtils.nullSafeEquals(this.clazz, classPathResource.clazz);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

