/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public abstract class ResourcePatternUtils {
    public static boolean isUrl(String string) {
        return string != null && (string.startsWith("classpath*:") || ResourceUtils.isUrl(string));
    }

    public static ResourcePatternResolver getResourcePatternResolver(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        if (resourceLoader instanceof ResourcePatternResolver) {
            return (ResourcePatternResolver)resourceLoader;
        }
        return new PathMatchingResourcePatternResolver(resourceLoader);
    }
}

