/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.ClassUtils;

public class TypeMismatchException
extends PropertyAccessException {
    public static final String ERROR_CODE = "typeMismatch";
    private Object value;
    private Class requiredType;

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, Class clazz) {
        this(propertyChangeEvent, clazz, null);
    }

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, Class clazz, Throwable throwable) {
        super(propertyChangeEvent, "Failed to convert property value of type [" + (propertyChangeEvent.getNewValue() != null ? ClassUtils.getQualifiedName(propertyChangeEvent.getNewValue().getClass()) : null) + "]" + (clazz != null ? " to required type [" + ClassUtils.getQualifiedName((Class)clazz) + "]" : "") + (propertyChangeEvent.getPropertyName() != null ? " for property '" + propertyChangeEvent.getPropertyName() + "'" : ""), throwable);
        this.value = propertyChangeEvent.getNewValue();
        this.requiredType = clazz;
    }

    public TypeMismatchException(Object object, Class clazz) {
        this(object, clazz, null);
    }

    public TypeMismatchException(Object object, Class clazz, Throwable throwable) {
        super("Failed to convert value of type [" + (object != null ? ClassUtils.getQualifiedName(object.getClass()) : null) + "]" + (clazz != null ? " to required type [" + ClassUtils.getQualifiedName((Class)clazz) + "]" : ""), throwable);
        this.value = object;
        this.requiredType = clazz;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getRequiredType() {
        return this.requiredType;
    }

    public String getErrorCode() {
        return ERROR_CODE;
    }
}

