/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultNamespaceHandlerResolver
implements NamespaceHandlerResolver {
    private static final String SPRING_HANDLER_MAPPINGS_LOCATION = "META-INF/spring.handlers";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map handlerMappings;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$NamespaceHandler;

    public DefaultNamespaceHandlerResolver() {
        this(null, SPRING_HANDLER_MAPPINGS_LOCATION);
    }

    public DefaultNamespaceHandlerResolver(ClassLoader classLoader) {
        this(classLoader, SPRING_HANDLER_MAPPINGS_LOCATION);
    }

    public DefaultNamespaceHandlerResolver(ClassLoader classLoader, String string) {
        Assert.notNull((Object)string, (String)"Handler mappings location must not be null");
        ClassLoader classLoader2 = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.initHandlerMappings(classLoader2, string);
    }

    private void initHandlerMappings(ClassLoader classLoader, String string) {
        Properties properties = this.loadMappings(classLoader, string);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded mappings [" + properties + "]"));
        }
        this.handlerMappings = new HashMap(properties.size());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            try {
                Class clazz = ClassUtils.forName((String)string3, (ClassLoader)classLoader);
                if (!(class$org$springframework$beans$factory$xml$NamespaceHandler == null ? DefaultNamespaceHandlerResolver.class$("org.springframework.beans.factory.xml.NamespaceHandler") : class$org$springframework$beans$factory$xml$NamespaceHandler).isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Class [" + string3 + "] does not implement the NamespaceHandler interface");
                }
                NamespaceHandler namespaceHandler = (NamespaceHandler)BeanUtils.instantiateClass(clazz);
                namespaceHandler.init();
                this.handlerMappings.put(string2, namespaceHandler);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignoring namespace handler [" + string3 + "]: handler class not found"), (Throwable)classNotFoundException);
            }
            catch (LinkageError linkageError) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Ignoring namespace handler [" + string3 + "]: problem with handler class file or dependent class"), (Throwable)linkageError);
            }
        }
    }

    private Properties loadMappings(ClassLoader classLoader, String string) {
        try {
            return PropertiesLoaderUtils.loadAllProperties((String)string, (ClassLoader)classLoader);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unable to load NamespaceHandler mappings from location [" + string + "]. Root cause: " + iOException);
        }
    }

    public NamespaceHandler resolve(String string) {
        return (NamespaceHandler)this.handlerMappings.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

