/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class NamespaceHandlerSupport
implements NamespaceHandler {
    private final Map parsers = new HashMap();
    private final Map decorators = new HashMap();
    private final Map attributeDecorators = new HashMap();

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        return this.findParserForElement(element, parserContext).parse(element, parserContext);
    }

    private BeanDefinitionParser findParserForElement(Element element, ParserContext parserContext) {
        BeanDefinitionParser beanDefinitionParser = (BeanDefinitionParser)this.parsers.get(element.getLocalName());
        if (beanDefinitionParser == null) {
            parserContext.getReaderContext().fatal("Cannot locate BeanDefinitionParser for element [" + element.getLocalName() + "]", element);
        }
        return beanDefinitionParser;
    }

    protected final BeanDefinitionParser findParserForElement(Element element) {
        BeanDefinitionParser beanDefinitionParser = (BeanDefinitionParser)this.parsers.get(element.getLocalName());
        if (beanDefinitionParser == null) {
            throw new IllegalStateException("Cannot locate BeanDefinitionParser for element [" + element.getLocalName() + "]");
        }
        return beanDefinitionParser;
    }

    public final BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder beanDefinitionHolder, ParserContext parserContext) {
        return this.findDecoratorForNode(node, parserContext).decorate(node, beanDefinitionHolder, parserContext);
    }

    private BeanDefinitionDecorator findDecoratorForNode(Node node, ParserContext parserContext) {
        BeanDefinitionDecorator beanDefinitionDecorator = null;
        if (node instanceof Element) {
            beanDefinitionDecorator = (BeanDefinitionDecorator)this.decorators.get(node.getLocalName());
        } else if (node instanceof Attr) {
            beanDefinitionDecorator = (BeanDefinitionDecorator)this.attributeDecorators.get(node.getLocalName());
        } else {
            parserContext.getReaderContext().fatal("Cannot decorate based on Nodes of type [" + node.getClass().getName() + "]", node);
        }
        if (beanDefinitionDecorator == null) {
            parserContext.getReaderContext().fatal("Cannot locate BeanDefinitionDecorator for " + (node instanceof Element ? "element" : "attribute") + " [" + node.getLocalName() + "]", node);
        }
        return beanDefinitionDecorator;
    }

    protected final BeanDefinitionDecorator findDecoratorForNode(Node node) {
        BeanDefinitionDecorator beanDefinitionDecorator = null;
        if (node instanceof Element) {
            beanDefinitionDecorator = (BeanDefinitionDecorator)this.decorators.get(node.getLocalName());
        } else if (node instanceof Attr) {
            beanDefinitionDecorator = (BeanDefinitionDecorator)this.attributeDecorators.get(node.getLocalName());
        } else {
            throw new IllegalStateException("Cannot decorate based on Nodes of type [" + node.getClass().getName() + "]");
        }
        if (beanDefinitionDecorator == null) {
            throw new IllegalStateException("Cannot locate BeanDefinitionDecorator for " + (node instanceof Element ? "element" : "attribute") + " [" + node.getLocalName() + "]");
        }
        return beanDefinitionDecorator;
    }

    protected final void registerBeanDefinitionParser(String string, BeanDefinitionParser beanDefinitionParser) {
        this.parsers.put(string, beanDefinitionParser);
    }

    protected final void registerBeanDefinitionDecorator(String string, BeanDefinitionDecorator beanDefinitionDecorator) {
        this.decorators.put(string, beanDefinitionDecorator);
    }

    protected final void registerBeanDefinitionDecoratorForAttribute(String string, BeanDefinitionDecorator beanDefinitionDecorator) {
        this.attributeDecorators.put(string, beanDefinitionDecorator);
    }
}

