/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JRootPane;

public class MintTitlePane
extends BaseTitlePane {
    public MintTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void createButtons() {
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.restoreAction, "Maximize", this.maximizeIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            if (this.backgroundImage != null) {
                graphics.drawImage(this.backgroundImage, 0, 0, null);
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.alphaValue);
                graphics2D.setComposite(alphaComposite);
            }
            JTattooUtilities.fillVerGradient(graphics, MintLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight());
            graphics2D.setComposite(composite);
        } else {
            JTattooUtilities.fillVerGradient(graphics, MintLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paintBorder(Graphics graphics) {
        graphics.setColor(ColorHelper.darker(MintLookAndFeel.getTheme().getWindowTitleColorDark(), 10.0));
        graphics.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }
}

