/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import com.sun.xml.internal.ws.wsdl.ActionBasedOperationSignature;
import com.sun.xml.internal.ws.wsdl.DispatchException;
import com.sun.xml.internal.ws.wsdl.PayloadQNameBasedOperationFinder;
import com.sun.xml.internal.ws.wsdl.WSDLOperationFinder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

final class ActionBasedOperationFinder
extends WSDLOperationFinder {
    private static final Logger LOGGER = Logger.getLogger(ActionBasedOperationFinder.class.getName());
    private final Map<ActionBasedOperationSignature, QName> uniqueOpSignatureMap;
    private final Map<String, QName> actionMap;
    @NotNull
    private final AddressingVersion av;

    public ActionBasedOperationFinder(WSDLPort wSDLPort, WSBinding wSBinding, @Nullable SEIModel sEIModel) {
        super(wSDLPort, wSBinding, sEIModel);
        assert (wSBinding.getAddressingVersion() != null);
        this.av = wSBinding.getAddressingVersion();
        this.uniqueOpSignatureMap = new HashMap<ActionBasedOperationSignature, QName>();
        this.actionMap = new HashMap<String, QName>();
        if (sEIModel != null) {
            for (JavaMethodImpl javaMethodImpl : ((AbstractSEIModelImpl)sEIModel).getJavaMethods()) {
                if (javaMethodImpl.getMEP().isAsync) continue;
                String string = javaMethodImpl.getInputAction();
                QName qName = javaMethodImpl.getRequestPayloadName();
                if (qName == null) {
                    qName = PayloadQNameBasedOperationFinder.EMPTY_PAYLOAD;
                }
                if (string == null || string.equals("")) {
                    string = javaMethodImpl.getOperation().getOperation().getInput().getAction();
                }
                if (string == null) continue;
                ActionBasedOperationSignature actionBasedOperationSignature = new ActionBasedOperationSignature(string, qName);
                if (this.uniqueOpSignatureMap.get(actionBasedOperationSignature) != null) {
                    LOGGER.warning(AddressingMessages.NON_UNIQUE_OPERATION_SIGNATURE(this.uniqueOpSignatureMap.get(actionBasedOperationSignature), javaMethodImpl.getOperation().getName(), string, qName));
                }
                this.uniqueOpSignatureMap.put(actionBasedOperationSignature, javaMethodImpl.getOperation().getName());
                this.actionMap.put(string, javaMethodImpl.getOperation().getName());
            }
        } else {
            for (WSDLBoundOperation wSDLBoundOperation : wSDLPort.getBinding().getBindingOperations()) {
                String string;
                ActionBasedOperationSignature actionBasedOperationSignature;
                QName qName = wSDLBoundOperation.getReqPayloadName();
                if (qName == null) {
                    qName = PayloadQNameBasedOperationFinder.EMPTY_PAYLOAD;
                }
                if (this.uniqueOpSignatureMap.get(actionBasedOperationSignature = new ActionBasedOperationSignature(string = wSDLBoundOperation.getOperation().getInput().getAction(), qName)) != null) {
                    LOGGER.warning(AddressingMessages.NON_UNIQUE_OPERATION_SIGNATURE(this.uniqueOpSignatureMap.get(actionBasedOperationSignature), wSDLBoundOperation.getName(), string, qName));
                }
                this.uniqueOpSignatureMap.put(actionBasedOperationSignature, wSDLBoundOperation.getName());
                this.actionMap.put(string, wSDLBoundOperation.getName());
            }
        }
    }

    @Override
    public QName getWSDLOperationQName(Packet packet) throws DispatchException {
        Object object;
        QName qName;
        HeaderList headerList = packet.getMessage().getHeaders();
        String string = headerList.getAction(this.av, this.binding.getSOAPVersion());
        if (string == null) {
            return null;
        }
        Message message = packet.getMessage();
        String string2 = message.getPayloadLocalPart();
        if (string2 == null) {
            qName = PayloadQNameBasedOperationFinder.EMPTY_PAYLOAD;
        } else {
            object = message.getPayloadNamespaceURI();
            if (object == null) {
                object = "";
            }
            qName = new QName((String)object, string2);
        }
        object = this.uniqueOpSignatureMap.get(new ActionBasedOperationSignature(string, qName));
        if (object != null) {
            return object;
        }
        object = this.actionMap.get(string);
        if (object != null) {
            return object;
        }
        Message message2 = Messages.create(string, this.av, this.binding.getSOAPVersion());
        throw new DispatchException(message2);
    }
}

