/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements TransferQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private static final boolean MP = Runtime.getRuntime().availableProcessors() > 1;
    private static final int FRONT_SPINS = 128;
    private static final int CHAINED_SPINS = 64;
    static final int SWEEP_THRESHOLD = 32;
    volatile transient Node head;
    private volatile transient Node tail;
    private volatile transient int sweepVotes;
    private static final int NOW = 0;
    private static final int ASYNC = 1;
    private static final int SYNC = 2;
    private static final int TIMED = 3;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long sweepVotesOffset;

    private boolean casTail(Node node, Node node2) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private boolean casHead(Node node, Node node2) {
        return UNSAFE.compareAndSwapObject(this, headOffset, node, node2);
    }

    private boolean casSweepVotes(int n, int n2) {
        return UNSAFE.compareAndSwapInt(this, sweepVotesOffset, n, n2);
    }

    static <E> E cast(Object object) {
        return (E)object;
    }

    private E xfer(E e, boolean bl, int n, long l) {
        block8: {
            Node node;
            if (bl && e == null) {
                throw new NullPointerException();
            }
            Node node2 = null;
            do {
                Node node3 = node = this.head;
                while (node3 != null) {
                    Node node4;
                    boolean bl2 = node3.isData;
                    Object object = node3.item;
                    if (object != node3 && object != null == bl2) {
                        if (bl2 == bl) break;
                        if (node3.casItem(object, e)) {
                            node4 = node3;
                            while (node4 != node) {
                                Node node5 = node4.next;
                                if (this.head == node && this.casHead(node, node5 == null ? node4 : node5)) {
                                    node.forgetNext();
                                    break;
                                }
                                node = this.head;
                                if (node != null && (node4 = node.next) != null && node4.isMatched()) continue;
                                break;
                            }
                            LockSupport.unpark(node3.waiter);
                            return LinkedTransferQueue.cast(object);
                        }
                    }
                    node3 = node3 != (node4 = node3.next) ? node4 : this.head;
                }
                if (n == 0) break block8;
                if (node2 != null) continue;
                node2 = new Node(e, bl);
            } while ((node = this.tryAppend(node2, bl)) == null);
            if (n != 1) {
                return this.awaitMatch(node2, node, e, n == 3, l);
            }
        }
        return e;
    }

    private Node tryAppend(Node node, boolean bl) {
        Node node2;
        Node node3 = node2 = this.tail;
        while (true) {
            if (node3 == null && (node3 = this.head) == null) {
                if (!this.casHead(null, node)) continue;
                return node;
            }
            if (node3.cannotPrecede(bl)) {
                return null;
            }
            Node node4 = node3.next;
            if (node4 != null) {
                Node node5;
                node3 = node3 != node2 && node2 != (node5 = this.tail) ? node5 : (node3 != node4 ? node4 : null);
                continue;
            }
            if (node3.casNext(null, node)) break;
            node3 = node3.next;
        }
        if (node3 != node2) {
            while (!(this.tail == node2 && this.casTail(node2, node) || (node2 = this.tail) == null || (node = node2.next) == null || (node = node.next) == null || node == node2)) {
            }
        }
        return node3;
    }

    private E awaitMatch(Node node, Node node2, E e, boolean bl, long l) {
        long l2 = bl ? System.nanoTime() : 0L;
        Thread thread = Thread.currentThread();
        int n = -1;
        Random random = null;
        while (true) {
            Object object;
            if ((object = node.item) != e) {
                node.forgetContents();
                return LinkedTransferQueue.cast(object);
            }
            if ((thread.isInterrupted() || bl && l <= 0L) && node.casItem(e, node)) {
                this.unsplice(node2, node);
                return e;
            }
            if (n < 0) {
                n = LinkedTransferQueue.spinsFor(node2, node.isData);
                if (n <= 0) continue;
                random = ThreadLocalRandom.current();
                continue;
            }
            if (n > 0) {
                --n;
                if (random.nextInt(64) != 0) continue;
                Thread.yield();
                continue;
            }
            if (node.waiter == null) {
                node.waiter = thread;
                continue;
            }
            if (bl) {
                long l3 = System.nanoTime();
                if ((l -= l3 - l2) > 0L) {
                    LockSupport.parkNanos(this, l);
                }
                l2 = l3;
                continue;
            }
            LockSupport.park(this);
        }
    }

    private static int spinsFor(Node node, boolean bl) {
        if (MP && node != null) {
            if (node.isData != bl) {
                return 192;
            }
            if (node.isMatched()) {
                return 128;
            }
            if (node.waiter == null) {
                return 64;
            }
        }
        return 0;
    }

    final Node succ(Node node) {
        Node node2 = node.next;
        return node == node2 ? this.head : node2;
    }

    private Node firstOfMode(boolean bl) {
        Node node = this.head;
        while (node != null) {
            if (!node.isMatched()) {
                return node.isData == bl ? node : null;
            }
            node = this.succ(node);
        }
        return null;
    }

    private E firstDataItem() {
        Node node = this.head;
        while (node != null) {
            Object object = node.item;
            if (node.isData) {
                if (object != null && object != node) {
                    return LinkedTransferQueue.cast(object);
                }
            } else if (object == null) {
                return null;
            }
            node = this.succ(node);
        }
        return null;
    }

    private int countOfMode(boolean bl) {
        int n = 0;
        Node node = this.head;
        while (node != null) {
            Node node2;
            if (!node.isMatched()) {
                if (node.isData != bl) {
                    return 0;
                }
                if (++n == Integer.MAX_VALUE) break;
            }
            if ((node2 = node.next) != node) {
                node = node2;
                continue;
            }
            n = 0;
            node = this.head;
        }
        return n;
    }

    final void unsplice(Node node, Node node2) {
        block6: {
            Node node3;
            node2.forgetContents();
            if (node == null || node == node2 || node.next != node2 || (node3 = node2.next) != null && (node3 == node2 || !node.casNext(node2, node3) || !node.isMatched())) break block6;
            while (true) {
                Node node4;
                if ((node4 = this.head) == node || node4 == node2 || node4 == null) {
                    return;
                }
                if (!node4.isMatched()) break;
                Node node5 = node4.next;
                if (node5 == null) {
                    return;
                }
                if (node5 == node4 || !this.casHead(node4, node5)) continue;
                node4.forgetNext();
            }
            if (node.next != node && node2.next != node2) {
                while (true) {
                    int n;
                    if ((n = this.sweepVotes) < 32) {
                        if (!this.casSweepVotes(n, n + 1)) continue;
                        break block6;
                    }
                    if (this.casSweepVotes(n, 0)) break;
                }
                this.sweep();
            }
        }
    }

    private void sweep() {
        Node node;
        Node node2 = this.head;
        while (node2 != null && (node = node2.next) != null) {
            if (!node.isMatched()) {
                node2 = node;
                continue;
            }
            Node node3 = node.next;
            if (node3 == null) break;
            if (node == node3) {
                node2 = this.head;
                continue;
            }
            node2.casNext(node, node3);
        }
    }

    private boolean findAndRemove(Object object) {
        if (object != null) {
            Node node = null;
            Node node2 = this.head;
            while (node2 != null) {
                Object object2 = node2.item;
                if (node2.isData) {
                    if (object2 != null && object2 != node2 && object.equals(object2) && node2.tryMatchData()) {
                        this.unsplice(node, node2);
                        return true;
                    }
                } else if (object2 == null) break;
                if ((node2 = node2.next) != (node = node2)) continue;
                node = null;
                node2 = this.head;
            }
        }
        return false;
    }

    public LinkedTransferQueue() {
    }

    public LinkedTransferQueue(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public void put(E e) {
        this.xfer(e, true, 1, 0L);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean offer(E e) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean add(E e) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean tryTransfer(E e) {
        return this.xfer(e, true, 0, 0L) == null;
    }

    @Override
    public void transfer(E e) throws InterruptedException {
        if (this.xfer(e, true, 2, 0L) != null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryTransfer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.xfer(e, true, 3, timeUnit.toNanos(l)) == null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public E take() throws InterruptedException {
        E e = this.xfer(null, false, 2, 0L);
        if (e != null) {
            return e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        E e = this.xfer(null, false, 3, timeUnit.toNanos(l));
        if (e != null || !Thread.interrupted()) {
            return e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return this.xfer(null, false, 0, 0L);
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        E e;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            collection.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        E e;
        int n2;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < n && (e = this.poll()) != null; ++n2) {
            collection.add(e);
        }
        return n2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        return this.firstDataItem();
    }

    @Override
    public boolean isEmpty() {
        Node node = this.head;
        while (node != null) {
            if (!node.isMatched()) {
                return !node.isData;
            }
            node = this.succ(node);
        }
        return true;
    }

    @Override
    public boolean hasWaitingConsumer() {
        return this.firstOfMode(false) != null;
    }

    @Override
    public int size() {
        return this.countOfMode(true);
    }

    @Override
    public int getWaitingConsumerCount() {
        return this.countOfMode(false);
    }

    @Override
    public boolean remove(Object object) {
        return this.findAndRemove(object);
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Node node = this.head;
        while (node != null) {
            Object object2 = node.item;
            if (node.isData) {
                if (object2 != null && object2 != node && object.equals(object2)) {
                    return true;
                }
            } else if (object2 == null) break;
            node = this.succ(node);
        }
        return false;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (E e : this) {
            objectOutputStream.writeObject(e);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            this.offer(object);
        }
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<LinkedTransferQueue> clazz = LinkedTransferQueue.class;
            headOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("tail"));
            sweepVotesOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("sweepVotes"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    final class Itr
    implements Iterator<E> {
        private Node nextNode;
        private E nextItem;
        private Node lastRet;
        private Node lastPred;

        private void advance(Node node) {
            Node node2;
            Node node3;
            Node node4 = this.lastRet;
            if (node4 != null && !node4.isMatched()) {
                this.lastPred = node4;
            } else {
                Node node5 = this.lastPred;
                if (node5 == null || node5.isMatched()) {
                    this.lastPred = null;
                } else {
                    while ((node3 = node5.next) != null && node3 != node5 && node3.isMatched() && (node2 = node3.next) != null && node2 != node3) {
                        node5.casNext(node3, node2);
                    }
                }
            }
            this.lastRet = node;
            node3 = node;
            while (true) {
                Node node6 = node2 = node3 == null ? LinkedTransferQueue.this.head : node3.next;
                if (node2 == null) break;
                if (node2 == node3) {
                    node3 = null;
                    continue;
                }
                Object object = node2.item;
                if (node2.isData) {
                    if (object != null && object != node2) {
                        this.nextItem = LinkedTransferQueue.cast(object);
                        this.nextNode = node2;
                        return;
                    }
                } else if (object == null) break;
                if (node3 == null) {
                    node3 = node2;
                    continue;
                }
                Node node7 = node2.next;
                if (node7 == null) break;
                if (node2 == node7) {
                    node3 = null;
                    continue;
                }
                node3.casNext(node2, node7);
            }
            this.nextNode = null;
            this.nextItem = null;
        }

        Itr() {
            this.advance(null);
        }

        @Override
        public final boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public final E next() {
            Node node = this.nextNode;
            if (node == null) {
                throw new NoSuchElementException();
            }
            Object e = this.nextItem;
            this.advance(node);
            return e;
        }

        @Override
        public final void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            if (node.tryMatchData()) {
                LinkedTransferQueue.this.unsplice(this.lastPred, node);
            }
        }
    }

    static final class Node {
        final boolean isData;
        volatile Object item;
        volatile Node next;
        volatile Thread waiter;
        private static final long serialVersionUID = -3375979862319811754L;
        private static final Unsafe UNSAFE;
        private static final long itemOffset;
        private static final long nextOffset;
        private static final long waiterOffset;

        final boolean casNext(Node node, Node node2) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, node, node2);
        }

        final boolean casItem(Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, object, object2);
        }

        Node(Object object, boolean bl) {
            UNSAFE.putObject((Object)this, itemOffset, object);
            this.isData = bl;
        }

        final void forgetNext() {
            UNSAFE.putObject((Object)this, nextOffset, (Object)this);
        }

        final void forgetContents() {
            UNSAFE.putObject((Object)this, itemOffset, (Object)this);
            UNSAFE.putObject((Object)this, waiterOffset, null);
        }

        final boolean isMatched() {
            Object object = this.item;
            return object == this || object == null == this.isData;
        }

        final boolean isUnmatchedRequest() {
            return !this.isData && this.item == null;
        }

        final boolean cannotPrecede(boolean bl) {
            Object object;
            boolean bl2 = this.isData;
            return bl2 != bl && (object = this.item) != this && object != null == bl2;
        }

        final boolean tryMatchData() {
            Object object = this.item;
            if (object != null && object != this && this.casItem(object, null)) {
                LockSupport.unpark(this.waiter);
                return true;
            }
            return false;
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Node> clazz = Node.class;
                itemOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("next"));
                waiterOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("waiter"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }
}

