/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.SecureRandom;

public final class JCAUtil {
    private static final Object LOCK = JCAUtil.class;
    private static volatile SecureRandom secureRandom;
    private static final int ARRAY_SIZE = 4096;

    private JCAUtil() {
    }

    public static int getTempArraySize(int n) {
        return Math.min(4096, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureRandom getSecureRandom() {
        SecureRandom secureRandom = JCAUtil.secureRandom;
        if (secureRandom == null) {
            Object object = LOCK;
            synchronized (object) {
                secureRandom = JCAUtil.secureRandom;
                if (secureRandom == null) {
                    JCAUtil.secureRandom = secureRandom = new SecureRandom();
                }
            }
        }
        return secureRandom;
    }
}

