/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.registration;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.registration.InstallCommands;
import com.sun.deploy.registration.InstallHints;
import com.sun.deploy.security.DeploySigningCertStore;
import java.io.File;
import java.io.FileOutputStream;

public class RegisterDeploy {
    private RegisterDeploy() {
    }

    public static final InstallCommands register(InstallHints installHints) {
        InstallCommands installCommands = null;
        if (installHints == null) {
            return installCommands;
        }
        if (installHints.getInstallType() == 2) {
            return RegisterDeploy.registerQuery(installHints);
        }
        if (installHints.getInstallType() == 1) {
            installCommands = RegisterDeploy.registerConfig(installHints);
        }
        return installCommands;
    }

    private static final InstallCommands registerQuery(InstallHints installHints) {
        int n;
        int n2;
        InstallCommands installCommands = new InstallCommands();
        if (installHints.getUserWebJavaStatusQuery()) {
            if (Platform.get().getWebJavaSwitch().queryWebJavaState() == Platform.WebJavaSwitch.WebJavaState.ENABLED) {
                installCommands.setUserWebJavaStatus(1);
            } else {
                installCommands.setUserWebJavaStatus(0);
            }
        }
        if (installHints.getUserPreviousDecisionsExistQuery() != -1) {
            n2 = installHints.getUserPreviousDecisionsExistQuery();
            n = RegisterDeploy.getUserPreviousDecisionsExist(n2);
            installCommands.setUserPreviousDecisionsExist(n);
        }
        if (installHints.getClearUserPreviousDecisionsQuery() != -1) {
            n2 = installHints.getClearUserPreviousDecisionsQuery();
            n = RegisterDeploy.clearUserPreviousDecisions(n2);
            installCommands.setClearUserPreviousDecisionsResult(n);
        }
        if (installHints.getResetUserPrevousDecisionsDateQuery() && !RegisterDeploy.resetUserPrevousDecisionsDate()) {
            installCommands.setInstallStatus(1);
        }
        return installCommands;
    }

    private static final InstallCommands registerConfig(InstallHints installHints) {
        InstallCommands installCommands = new InstallCommands();
        if (installHints.getWebJavaEnabled() != -1 && !RegisterDeploy.setWebJavaEnabled(installHints.getWebJavaEnabled() == 1)) {
            installCommands.setInstallStatus(1);
        }
        if (installHints.getCustomSecurityLevel() != -1 && !RegisterDeploy.setSystemSecurityLevel(installHints.getCustomSecurityLevel())) {
            installCommands.setInstallStatus(1);
        }
        return installCommands;
    }

    private static final int getUserPreviousDecisionsExist(int n) {
        if (DeploySigningCertStore.checkStoredCertificates(1, n, false, false)) {
            return 1;
        }
        if (DeploySigningCertStore.checkStoredCertificates(4, n, false, false)) {
            return 1;
        }
        return 0;
    }

    private static final int clearUserPreviousDecisions(int n) {
        boolean bl = DeploySigningCertStore.checkStoredCertificates(1, n, true, false);
        boolean bl2 = DeploySigningCertStore.checkStoredCertificates(4, n, true, false);
        return bl || bl2 ? 1 : 0;
    }

    private static final boolean resetUserPrevousDecisionsDate() {
        boolean bl = DeploySigningCertStore.checkStoredCertificates(1, 0, false, true);
        boolean bl2 = DeploySigningCertStore.checkStoredCertificates(4, 0, false, true);
        return bl || bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final boolean hasSystemConfigAccess() {
        boolean bl = false;
        File file = null;
        try {
            try {
                File file2 = new File(Config.getSystemHome());
                file2.mkdirs();
                file = new File(Config.getSystemHome() + File.separator + Config.getPropertiesFilename());
                bl = file.createNewFile();
                new FileOutputStream(file).close();
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                Object var5_5 = null;
                if (file == null) return bl2;
                if (!bl) return bl2;
                file.delete();
                return bl2;
            }
            Object var5_4 = null;
            if (file == null) return true;
            if (!bl) return true;
            file.delete();
            return true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (file == null) throw throwable;
            if (!bl) throw throwable;
            file.delete();
            throw throwable;
        }
    }

    private static final boolean setSystemSecurityLevel(int n) {
        if (n < 0 || n >= SecuritySettings.SECURITY_LEVELS.length) {
            System.out.println("unsupported security level: " + n);
            System.out.println("support level is 0 (medium), 1 (high), 2 (very high)");
            return false;
        }
        if (!RegisterDeploy.hasSystemConfigAccess()) {
            System.out.println("user has no access to system settings");
            return false;
        }
        SecuritySettings.setInstallerRecommendedSecurityLevel(n);
        return true;
    }

    private static final boolean setWebJavaEnabled(boolean bl) {
        if (!RegisterDeploy.hasSystemConfigAccess()) {
            System.out.println("user has no access to system settings");
            return false;
        }
        Platform.get().getWebJavaSwitch().setWebJavaEnabled(bl);
        return true;
    }
}

