/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.DownloadErrorEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.MultipleHostsException;
import com.sun.javaws.exceptions.NativeLibViolationException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LDUpdater;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class LaunchDownload {
    private final LaunchDesc ld;
    public static final String APPCONTEXT_THREADPOOL_KEY = "deploy-launchdownloadthreadpoolinappcontext";

    public LaunchDownload(LaunchDesc launchDesc) {
        this.ld = launchDesc;
    }

    public static LaunchDesc updateLaunchDescInCache(LaunchDesc launchDesc) {
        return LaunchDownload.updateLaunchDescInCache(launchDesc, null, null);
    }

    public static LaunchDesc updateLaunchDescInCache(LaunchDesc launchDesc, URL uRL, URL uRL2) {
        if (!Cache.isCacheEnabled()) {
            return launchDesc;
        }
        boolean bl = launchDesc.getLocation() == null;
        URL uRL3 = bl ? launchDesc.getCanonicalHome() : launchDesc.getLocation();
        try {
            File file = ResourceProvider.get().getCachedJNLPFile(uRL3, null);
            if (file == null) {
                Resource resource;
                Cache.createOrUpdateCacheEntry((URL)uRL3, (byte[])launchDesc.getBytes());
                URL uRL4 = launchDesc.getSourceURL();
                if (uRL4 != null && uRL3 != null && !uRL4.toString().equals(uRL3.toString()) && (resource = ResourceProvider.get().getCachedResource(uRL4, null)) != null) {
                    ResourceProvider.get().markRetired(resource, false);
                }
                return launchDesc;
            }
            Trace.println((String)("Loaded descriptor from cache at: " + uRL3), (TraceLevel)TraceLevel.BASIC);
            LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(file, uRL, uRL2, null);
            if (launchDesc.hasIdenticalContent(launchDesc2)) {
                return launchDesc2;
            }
            Cache.createOrUpdateCacheEntry((URL)uRL3, (byte[])launchDesc.getBytes());
            return launchDesc;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        catch (BadFieldException badFieldException) {
            Trace.ignoredException((Exception)badFieldException);
        }
        catch (MissingFieldException missingFieldException) {
            Trace.ignoredException((Exception)missingFieldException);
        }
        catch (JNLParseException jNLParseException) {
            Trace.ignoredException((Exception)jNLParseException);
        }
        return launchDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LaunchDesc getUpdatedLaunchDesc(URL uRL, URL uRL2, boolean bl) throws JNLPException, IOException {
        Object object;
        boolean bl2;
        ResourceProvider resourceProvider;
        block16: {
            resourceProvider = ResourceProvider.get();
            if (uRL == null) {
                return null;
            }
            Resource resource = resourceProvider.getCachedResource(uRL, null);
            if (resource != null) {
                try {
                    if (bl) {
                        bl2 = resourceProvider.checkUpdateAvailable(uRL, resource, 1, null);
                        break block16;
                    }
                    bl2 = resourceProvider.isUpdateAvailable(uRL, null);
                }
                catch (IOException iOException) {
                    Trace.ignored((Throwable)iOException);
                    bl2 = false;
                }
            } else {
                bl2 = true;
            }
        }
        if (!bl2) {
            Trace.println((String)("Update JNLP: no update for: " + uRL), (TraceLevel)TraceLevel.BASIC);
            return null;
        }
        Trace.println((String)("Update JNLP: " + uRL + ", thisCodebase: " + uRL2), (TraceLevel)TraceLevel.BASIC);
        File file = null;
        int n = ResourceProvider.get().incrementInternalUse();
        try {
            object = resourceProvider.downloadUpdate(uRL, null);
            file = object.getDataFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.ignoredException((Exception)fileNotFoundException);
        }
        finally {
            ResourceProvider.get().decrementInternalUse(n);
        }
        if (file != null) {
            object = null;
            try {
                object = LaunchDescFactory.buildDescriptor(file, uRL2, uRL, uRL);
                return object;
            }
            catch (LaunchDescException launchDescException) {
                object = LaunchDescFactory.buildDescriptor(file);
                if (object == null) {
                    throw launchDescException;
                }
                return object;
            }
        }
        return LaunchDescFactory.buildDescriptor(uRL, uRL);
    }

    public static boolean isJnlpCached(LaunchDesc launchDesc) {
        try {
            return ResourceProvider.get().isCached(launchDesc.getCanonicalHome(), null);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return false;
        }
    }

    public boolean isInCache() {
        return this.isInCache(false);
    }

    public boolean isInCache(boolean bl) {
        ResourcesDesc resourcesDesc = this.ld.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        try {
            boolean bl2;
            if (this.ld.getLocation() != null && !ResourceProvider.get().isCached(this.ld.getLocation(), null)) {
                return false;
            }
            if (!bl && !(bl2 = this.getCachedExtensions())) {
                return false;
            }
            bl2 = Environment.isImportMode();
            JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(bl2);
            for (int i = 0; i < jARDescArray.length; ++i) {
                JARDesc jARDesc = jARDescArray[i];
                Resource resource = ResourceProvider.get().getCachedResource(jARDesc.getLocation(), jARDesc.getVersion());
                if (resource == null) {
                    return false;
                }
                if (!this.checkJarFileCorrupted(resource)) continue;
                return false;
            }
        }
        catch (JNLPException jNLPException) {
            Trace.ignoredException((Exception)jNLPException);
            return false;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return false;
        }
        return true;
    }

    private static boolean isUpdateAvailable(LaunchDesc launchDesc) throws JNLPException {
        try {
            return new LDUpdater(launchDesc).isUpdateAvailable();
        }
        catch (Exception exception) {
            if (exception instanceof JNLPException) {
                throw (JNLPException)exception;
            }
            if (exception.getCause() instanceof JNLPException) {
                throw (JNLPException)exception.getCause();
            }
            throw new FailedDownloadingResourceException(launchDesc.getLocation(), null, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkJarFileCorrupted(Resource resource) {
        if (resource == null || resource.getDataFile() == null) {
            return true;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(resource.getDataFile());
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            ResourceProvider.get().markRetired(resource, false);
            boolean bl = true;
            return bl;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void downloadExtensions(Preloader preloader, int n, ArrayList arrayList) throws IOException, JNLPException {
        this.downloadExtensionsHelper(preloader, n, false, arrayList);
    }

    public boolean getCachedExtensions() throws IOException, JNLPException {
        return this.downloadExtensionsHelper(null, 0, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadExtensionsHelper(Preloader preloader, int n, boolean bl, ArrayList arrayList) throws IOException, JNLPException {
        int n2 = ResourceProvider.get().incrementInternalUse();
        try {
            boolean bl2 = this._downloadExtensionsHelper(preloader, n, bl, arrayList);
            return bl2;
        }
        finally {
            ResourceProvider.get().decrementInternalUse(n2);
        }
    }

    private boolean _downloadExtensionsHelper(Preloader preloader, int n, boolean bl, ArrayList arrayList) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = this.ld.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        String string = JREInfo.getKnownPlatforms();
        final ArrayList arrayList2 = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList2.add(extensionDesc);
            }
        });
        n += arrayList2.size();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Object object;
            int n2;
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList2.get(i);
            String string2 = extensionDesc.getName();
            if (string2 == null && (n2 = (string2 = extensionDesc.getLocation().toString()).lastIndexOf(47)) > 0) {
                string2 = string2.substring(n2 + 1, string2.length());
            }
            --n;
            if (preloader != null) {
                preloader.handleEvent((PreloaderEvent)new DownloadEvent(0, extensionDesc.getLocation(), extensionDesc.getVersion(), string2, (long)n, (long)arrayList2.size(), arrayList2.size()));
            }
            Resource resource = ResourceProvider.get().getJreResource(extensionDesc.getLocation(), extensionDesc.getVersion(), !bl, false, JREInfo.getKnownPlatforms());
            File file = resource != null ? resource.getDataFile() : null;
            Trace.println((String)("Downloaded extension: " + extensionDesc.getLocation() + "\n\tcodebase: " + extensionDesc.getCodebase() + "\n\tld parentCodebase: " + this.ld.getCodebase() + "\n\tfile: " + file), (TraceLevel)TraceLevel.NETWORK);
            if (file == null) {
                return false;
            }
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, extensionDesc.getCodebase(), extensionDesc.getLocation(), extensionDesc.getLocation());
            boolean bl2 = false;
            if (launchDesc.getLaunchType() == 3) {
                bl2 = true;
            } else if (launchDesc.getLaunchType() == 4) {
                object = Cache.getLocalApplicationProperties((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion(), (boolean)false);
                boolean bl3 = bl2 = !object.isExtensionInstalled();
                if (arrayList != null && (LaunchDownload.isUpdateAvailable(launchDesc) || bl2)) {
                    arrayList.add(file);
                }
                if (bl && bl2) {
                    return false;
                }
            } else {
                throw new MissingFieldException(launchDesc.getSource(), "<component-desc>|<installer-desc>");
            }
            if (!bl2) continue;
            extensionDesc.setExtensionDesc(launchDesc);
            object = new LaunchDownload(launchDesc);
            boolean bl4 = super.downloadExtensionsHelper(preloader, n, bl, arrayList);
            if (bl4) continue;
            return false;
        }
        return true;
    }

    public static void downloadResource(LaunchDesc launchDesc, URL uRL, String string, Preloader preloader, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        int n = resourcesDesc.getConcurrentDownloads();
        JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
        LaunchDownload.downloadJarFiles(jARDescArray, preloader, bl, n);
    }

    public static void downloadParts(LaunchDesc launchDesc, String[] stringArray, Preloader preloader, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        int n = resourcesDesc.getConcurrentDownloads();
        JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, preloader, bl, n);
    }

    public static void downloadExtensionPart(LaunchDesc launchDesc, URL uRL, String string, String[] stringArray, Preloader preloader, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        int n = resourcesDesc.getConcurrentDownloads();
        JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, preloader, bl, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadEagerorAll(boolean bl, Preloader preloader, boolean bl2) throws IOException, JNLPException {
        int n;
        Object object;
        JARDesc[] jARDescArray;
        ResourcesDesc resourcesDesc = this.ld.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray2 = resourcesDesc.getEagerOrAllJarDescs(bl);
        if (!bl && (jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true)).length != jARDescArray2.length) {
            object = new HashSet<JARDesc>(Arrays.asList(jARDescArray2));
            n = 0;
            for (int i = 0; i < jARDescArray.length; ++i) {
                URL uRL = jARDescArray[i].getLocation();
                String string = jARDescArray[i].getVersion();
                if (!((HashSet)object).contains(jARDescArray[i]) && ResourceProvider.get().isCached(uRL, string)) {
                    ++n;
                    continue;
                }
                jARDescArray[i] = null;
            }
            if (n > 0) {
                JARDesc[] jARDescArray3 = new JARDesc[jARDescArray2.length + n];
                System.arraycopy(jARDescArray2, 0, jARDescArray3, 0, jARDescArray2.length);
                int n2 = jARDescArray2.length;
                for (int i = 0; i < jARDescArray.length; ++i) {
                    if (jARDescArray[i] == null) continue;
                    jARDescArray3[n2++] = jARDescArray[i];
                }
                jARDescArray2 = jARDescArray3;
            }
        }
        int n3 = this.ld.getResources().getConcurrentDownloads();
        Trace.println((String)("LaunchDownload: concurrent downloads from LD: " + n3), (TraceLevel)TraceLevel.NETWORK);
        LaunchDownload.downloadJarFiles(jARDescArray2, preloader, bl2, n3);
        object = this.ld.getInformation().getIconLocation(48, 0);
        if (object != null) {
            n = ResourceProvider.get().incrementInternalUse();
            try {
                ResourceProvider.get().getResource(((IconDesc)object).getLocation(), ((IconDesc)object).getVersion(), true, 1, null);
                Trace.println((String)("Downloaded " + ((IconDesc)object).getLocation()), (TraceLevel)TraceLevel.NETWORK);
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
            finally {
                ResourceProvider.get().decrementInternalUse(n);
            }
        }
    }

    public static void reverse(JARDesc[] jARDescArray) {
        int n = 0;
        for (int i = jARDescArray.length - 1; n < i; ++n, --i) {
            JARDesc jARDesc = jARDescArray[n];
            jARDescArray[n] = jARDescArray[i];
            jARDescArray[i] = jARDesc;
        }
    }

    public static int getDownloadType(JARDesc jARDesc) {
        int n = 256;
        if (jARDesc.isNativeLib()) {
            n |= 0x10;
        }
        if (jARDesc.isPack200Enabled()) {
            n |= 0x1000;
        }
        if (jARDesc.isVersionEnabled()) {
            n |= 0x10000;
        }
        return n;
    }

    public void prepareCustomProgress(PreloaderDelegate preloaderDelegate, JNLPSignedResourcesHelper jNLPSignedResourcesHelper, Runnable runnable, Runnable runnable2, boolean bl) {
        this.prepareCustomProgress(preloaderDelegate, jNLPSignedResourcesHelper, runnable, runnable2, bl, true);
    }

    void prepareCustomProgress(final PreloaderDelegate preloaderDelegate, final JNLPSignedResourcesHelper jNLPSignedResourcesHelper, final Runnable runnable, final Runnable runnable2, final boolean bl, boolean bl2) {
        DeployPerfUtil.put((String)"begining of prepareCustomProgress()");
        preloaderDelegate.setPreloaderClass(this.ld.getProgressClassName());
        preloaderDelegate.markLoadingStarted();
        Runnable runnable3 = new Runnable(){

            public void run() {
                block5: {
                    try {
                        if (bl) {
                            LaunchDownload.this.downloadProgressJars(preloaderDelegate);
                        }
                        if (runnable != null) {
                            runnable.run();
                        }
                        preloaderDelegate.markLoaded(null);
                        jNLPSignedResourcesHelper.warmup();
                    }
                    catch (Exception exception) {
                        Exception exception2;
                        if (exception instanceof RuntimeException) {
                            exception2 = exception.getCause() instanceof Exception ? (Exception)exception.getCause() : exception;
                        }
                        Trace.println((String)("Error preparing preloader : " + exception2), (TraceLevel)TraceLevel.PRELOADER);
                        Trace.ignored((Throwable)exception2);
                        preloaderDelegate.markLoaded(exception2);
                        if (runnable2 == null) break block5;
                        runnable2.run();
                    }
                }
            }
        };
        if (bl2) {
            Thread thread = new Thread(runnable3, "Loading Custom Progress");
            thread.setDaemon(true);
            thread.start();
        } else {
            runnable3.run();
        }
    }

    void downloadProgressJars(PreloaderDelegate preloaderDelegate) throws IOException, JNLPException {
        ExecutorService executorService = null;
        List list = null;
        ResourcesDesc resourcesDesc = this.ld.getResources();
        if (resourcesDesc == null) {
            return;
        }
        executorService = LaunchDownload.getThreadPool(2);
        if (executorService == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(false);
        ArrayList<DownloadTask> arrayList = new ArrayList<DownloadTask>(2);
        for (int i = 0; i < jARDescArray.length; ++i) {
            DownloadTask downloadTask;
            JARDesc jARDesc = jARDescArray[i];
            if (!jARDesc.isProgressJar() || arrayList.contains(downloadTask = new DownloadTask(jARDesc.getLocation(), null, jARDesc.getVersion(), null, true, LaunchDownload.getDownloadType(jARDesc), null, null, null))) continue;
            arrayList.add(downloadTask);
        }
        if (arrayList.size() > 0) {
            try {
                list = executorService.invokeAll(arrayList);
            }
            catch (InterruptedException interruptedException) {
                Trace.ignored((Throwable)interruptedException);
                executorService.shutdownNow();
            }
            executorService.shutdown();
            LaunchDownload.validateResults(list, arrayList, null);
        }
    }

    private static void downloadJarFiles(JARDesc[] jARDescArray, Preloader preloader, boolean bl, int n) throws JNLPException, IOException {
        int n2;
        int n3;
        if (jARDescArray == null) {
            return;
        }
        DeployPerfUtil.put((String)"LaunchDownload.downloadJarFiles - begin");
        if (Globals.isReverseMode()) {
            LaunchDownload.reverse(jARDescArray);
        }
        long l = 0L;
        DownloadCallbackHelper downloadCallbackHelper = DownloadCallbackHelper.get(preloader);
        int n4 = 0;
        boolean bl2 = true;
        for (n3 = 0; n3 < jARDescArray.length; ++n3) {
            n2 = jARDescArray[n3].getSize();
            if (jARDescArray[n3].isProgressJar()) continue;
            if (n2 > 0) {
                ++n4;
                l += (long)n2;
                continue;
            }
            bl2 = false;
        }
        n3 = 0;
        for (n2 = 0; n2 < jARDescArray.length; ++n2) {
            int n5 = jARDescArray[n2].getSize();
            if (jARDescArray[n2].isProgressJar()) continue;
            if (n5 <= 0) {
                downloadCallbackHelper.register(jARDescArray[n2].getLocation().toString(), jARDescArray[n2].getVersion(), 0, 1.0);
            } else if (n5 > 0) {
                downloadCallbackHelper.register(jARDescArray[n2].getLocation().toString(), jARDescArray[n2].getVersion(), n5, 0.5 + (double)(n5 * n4) / (double)l);
            }
            ++n3;
        }
        if (!bl2) {
            l = -1L;
        }
        Trace.println((String)("Total size to download: " + l), (TraceLevel)TraceLevel.NETWORK);
        if (l == 0L) {
            return;
        }
        downloadCallbackHelper.setTotalSize(l);
        downloadCallbackHelper.setNumOfJars(jARDescArray.length);
        int[] nArray = new int[]{0};
        ExecutorService executorService = LaunchDownload.getThreadPool(n);
        if (executorService != null) {
            ToolkitStore.get().getAppContext().put((Object)APPCONTEXT_THREADPOOL_KEY, (Object)executorService);
            downloadCallbackHelper.setNumOfJars(n3);
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>(jARDescArray.length);
        for (int i = 0; i < jARDescArray.length; ++i) {
            JARDesc jARDesc = jARDescArray[i];
            int n6 = ResourceProvider.get().incrementInternalUse();
            try {
                Object object;
                int n7 = LaunchDownload.getDownloadType(jARDesc);
                if (executorService == null) {
                    object = ResourceProvider.get().getResource(jARDesc.getLocation(), jARDesc.getVersion(), true, n7, (DownloadDelegate)downloadCallbackHelper);
                    nArray[0] = nArray[0] + 1;
                    downloadCallbackHelper.setJarsDone(nArray[0]);
                    if (!Cache.isCacheEnabled() || object != null || Environment.isImportMode()) continue;
                    throw new FailedDownloadingResourceException(null, jARDesc.getLocation(), jARDesc.getVersion(), null);
                }
                if (jARDesc.isProgressJar() || arrayList.contains(object = new DownloadTask(jARDesc.getLocation(), null, jARDesc.getVersion(), downloadCallbackHelper, true, n7, preloader, nArray, downloadCallbackHelper))) continue;
                arrayList.add((Resource)object);
                continue;
            }
            catch (JNLPException jNLPException) {
                if (preloader != null) {
                    preloader.handleEvent((PreloaderEvent)new DownloadErrorEvent(jARDesc.getLocation(), jARDesc.getVersion()));
                }
                throw jNLPException;
            }
            finally {
                ResourceProvider.get().decrementInternalUse(n6);
            }
        }
        List list = null;
        try {
            if (executorService != null) {
                list = executorService.invokeAll(arrayList);
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
        if (executorService != null) {
            ToolkitStore.get().getAppContext().remove((Object)APPCONTEXT_THREADPOOL_KEY);
            executorService.shutdown();
            LaunchDownload.validateResults(list, arrayList, preloader);
        }
        DeployPerfUtil.put((String)"LaunchDownload.downloadJarFiles - end");
    }

    private static void validateResults(List list, ArrayList arrayList, Preloader preloader) throws IOException, JNLPException {
        if (list != null) {
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                URL uRL = ((DownloadTask)arrayList.get(n)).getURL();
                String string = ((DownloadTask)arrayList.get(n)).getVersion();
                ++n;
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (null == throwable) continue;
                    if (throwable instanceof IOException) {
                        if (preloader != null) {
                            preloader.handleEvent((PreloaderEvent)new DownloadErrorEvent(uRL, string, throwable));
                        }
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof JNLPException) {
                        if (preloader != null) {
                            preloader.handleEvent((PreloaderEvent)new DownloadErrorEvent(uRL, string));
                        }
                        throw (JNLPException)throwable;
                    }
                    throw new IOException("JNLP Jar download failure.");
                }
                catch (InterruptedException interruptedException) {
                    Trace.ignored((Throwable)interruptedException);
                }
            }
        }
    }

    private static synchronized void notifyProgress(DownloadCallbackHelper downloadCallbackHelper, int[] nArray, URL uRL) {
        if (nArray != null && downloadCallbackHelper != null) {
            nArray[0] = nArray[0] + 1;
            Trace.println((String)("Download Progress: jarsDone: " + nArray[0]), (TraceLevel)TraceLevel.NETWORK);
            downloadCallbackHelper.jarDone(uRL);
            downloadCallbackHelper.setJarsDone(nArray[0]);
        }
    }

    private static ExecutorService getThreadPool(int n) {
        if (Config.isJavaVersionAtLeast15()) {
            ExecutorService executorService = Executors.newFixedThreadPool(n, new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            return executorService;
        }
        return null;
    }

    public static void checkJNLPSecurity(LaunchDesc launchDesc) throws MultipleHostsException, NativeLibViolationException {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(true);
        if (jARDesc == null) {
            return;
        }
        LaunchDownload.checkJNLPSecurityHelper(launchDesc, jARDesc.getLocation().getHost(), blArray2, blArray);
        if (blArray2[0]) {
            throw new MultipleHostsException();
        }
        if (blArray[0]) {
            throw new NativeLibViolationException();
        }
    }

    private static void checkJNLPSecurityHelper(LaunchDesc launchDesc, final String string, final boolean[] blArray, final boolean[] blArray2) {
        if (launchDesc.getSecurityModel() != 0) {
            return;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                String string2 = jARDesc.getLocation().getHost();
                blArray[0] = blArray[0] || !string.equals(string2);
                blArray2[0] = blArray2[0] || jARDesc.isNativeLib();
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (!blArray[0] && !blArray2[0]) {
                    LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                    String string2 = extensionDesc.getLocation().getHost();
                    if (launchDesc != null && launchDesc.getSecurityModel() == 0 && !blArray[0]) {
                        LaunchDownload.checkJNLPSecurityHelper(launchDesc, string2, blArray, blArray2);
                    }
                }
            }
        });
    }

    public static long getCachedSize(LaunchDesc launchDesc) {
        long l = 0L;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return l;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            Resource resource = ResourceProvider.get().getCachedResource(jARDescArray[i].getLocation(), jARDescArray[i].getVersion());
            if (resource == null) continue;
            l += resource.getSize();
        }
        IconDesc[] iconDescArray = launchDesc.getInformation().getIcons();
        if (iconDescArray != null) {
            for (int i = 0; i < iconDescArray.length; ++i) {
                Resource resource = ResourceProvider.get().getCachedResource(iconDescArray[i].getLocation(), iconDescArray[i].getVersion());
                if (resource == null) continue;
                l += resource.getSize();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassName(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException, LaunchDescException {
        String string = null;
        string = launchDesc.getMainClassName();
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        ZipFile zipFile = null;
        Manifest manifest = null;
        try {
            String string2;
            zipFile = new JarFile(ResourceProvider.get().getCachedJNLPFile(jARDesc.getLocation(), jARDesc.getVersion()), false);
            if (zipFile != null && launchDesc.getLaunchType() != 2 && (manifest = ((JarFile)zipFile).getManifest()) != null) {
                string = DeployManifestChecker.verifyMainClass((String)string, (Attributes)manifest.getMainAttributes());
            }
            if (string == null) {
                throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclassspec"), null);
            }
            String string3 = string2 = manifest == null ? null : manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (string2 == null) {
                String string4 = string;
                return string4;
            }
            String string5 = string.replace('.', '/') + ".class";
            if (((JarFile)zipFile).getEntry(string5) == null) {
                throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclass", (String)string, (String)jARDesc.getLocation().toString()), null);
            }
            String string6 = string;
            return string6;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public static boolean inCache(JARDesc jARDesc) {
        return ResourceProvider.get().isCached(jARDesc.getLocation(), jARDesc.getVersion());
    }

    private static class DownloadTask
    implements Callable {
        private URL url;
        private int downloadType;
        private String resourceID;
        private String versionString;
        private DownloadDelegate dd;
        private final boolean doDownload;
        private Preloader dp;
        private int[] counterBox;
        private DownloadCallbackHelper dch;

        public DownloadTask(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, int n, Preloader preloader, int[] nArray, DownloadCallbackHelper downloadCallbackHelper) {
            this.url = uRL;
            this.downloadType = n;
            this.resourceID = string;
            this.versionString = string2;
            this.dd = downloadDelegate;
            this.doDownload = bl;
            this.dp = preloader;
            this.counterBox = nArray;
            this.dch = downloadCallbackHelper;
        }

        public URL getURL() {
            return this.url;
        }

        public String getVersion() {
            return this.versionString;
        }

        public int hashCode() {
            if (this.url == null) {
                return 0;
            }
            return this.url.hashCode();
        }

        public String toString() {
            return this.url.toString() + (this.versionString != null ? ":" + this.versionString : "");
        }

        public boolean equals(Object object) {
            if (object instanceof DownloadTask) {
                DownloadTask downloadTask = (DownloadTask)object;
                URL uRL = downloadTask.getURL();
                String string = downloadTask.getVersion();
                if (this.url.toString().equals(uRL.toString())) {
                    if (this.versionString == null && string == null) {
                        return true;
                    }
                    if (this.versionString != null && string != null && this.versionString.equals(string)) {
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws IOException, JNLPException {
            int n = ResourceProvider.get().incrementInternalUse();
            try {
                URL uRL;
                Resource resource = ResourceProvider.get().getResource(this.url, this.versionString, this.doDownload, this.downloadType, (DownloadDelegate)this.dch);
                URL uRL2 = uRL = resource != null ? URLUtil.fileToURL((File)resource.getDataFile()) : null;
                if (Cache.isCacheEnabled() && uRL == null && !Environment.isImportMode()) {
                    throw new FailedDownloadingResourceException(null, this.url, this.versionString, null);
                }
                LaunchDownload.notifyProgress(this.dch, this.counterBox, this.url);
            }
            finally {
                ResourceProvider.get().decrementInternalUse(n);
            }
            return null;
        }
    }

    private static class DownloadCallbackHelper
    implements DownloadDelegate {
        Preloader _preloader;
        long _totalSize = -1L;
        final ArrayList _records;
        int _numOfJars = 1;
        int _jarsDone = 0;
        private static WeakHashMap helpers = new WeakHashMap();

        private DownloadCallbackHelper(Preloader preloader) {
            this._preloader = preloader;
            this._records = new ArrayList();
        }

        static DownloadCallbackHelper get(Preloader preloader) {
            DownloadCallbackHelper downloadCallbackHelper = (DownloadCallbackHelper)helpers.get(preloader);
            if (downloadCallbackHelper == null) {
                downloadCallbackHelper = new DownloadCallbackHelper(preloader);
                helpers.put(preloader, downloadCallbackHelper);
            }
            return downloadCallbackHelper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(String string, String string2, int n, double d) {
            ProgressRecord progressRecord = this.getProgressRecord(string);
            if (progressRecord == null) {
                progressRecord = new ProgressRecord(string, string2, n);
                progressRecord.setWeight(d);
                ArrayList arrayList = this._records;
                synchronized (arrayList) {
                    this._records.add(progressRecord);
                }
            } else {
                progressRecord.setWeight(d);
                progressRecord.setSize(n);
            }
        }

        public void setTotalSize(long l) {
            this._totalSize = l;
        }

        public void setNumOfJars(int n) {
            this._numOfJars = n;
        }

        public void setJarsDone(int n) {
            this._jarsDone = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloading(URL uRL, String string, int n, int n2, boolean bl) throws CancelException {
            if (this._preloader != null) {
                String string2 = uRL.toString();
                ProgressRecord progressRecord = this.getProgressRecord(string2);
                if (progressRecord == null) {
                    progressRecord = new ProgressRecord(string2, string, n2);
                    ArrayList arrayList = this._records;
                    synchronized (arrayList) {
                        this._records.add(progressRecord);
                    }
                } else {
                    progressRecord.setSize(n2);
                }
                progressRecord.downloadProgress(n);
                int n3 = this.getOverallPercent();
                this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(0, uRL, string, null, (long)n, (long)n2, n3));
            }
        }

        public void patching(URL uRL, String string, int n) throws CancelException {
            String string2;
            ProgressRecord progressRecord;
            if (this._preloader != null && (progressRecord = this.getProgressRecord(string2 = uRL.toString())) != null) {
                progressRecord.patchProgress(n);
                int n2 = this.getOverallPercent();
                this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(2, uRL, string, null, (long)n, 100L, n2));
            }
        }

        public void validating(URL uRL, int n, int n2) throws CancelException {
            String string;
            ProgressRecord progressRecord;
            if (this._preloader != null && (progressRecord = this.getProgressRecord(string = uRL.toString())) != null) {
                progressRecord.cacheTotalElements(n2);
                progressRecord.validateProgress(n, n2);
                int n3 = this.getOverallPercent();
                this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(1, uRL, null, null, (long)n, (long)n2, n3));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProgressRecord getProgressRecord(String string) {
            ArrayList arrayList = this._records;
            synchronized (arrayList) {
                Iterator iterator = this._records.iterator();
                while (iterator.hasNext()) {
                    ProgressRecord progressRecord = (ProgressRecord)iterator.next();
                    if (string == null || !string.equals(progressRecord.getUrl())) continue;
                    return progressRecord;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getOverallPercent() {
            double d = 0.0;
            double d2 = 0.0;
            ArrayList arrayList = this._records;
            synchronized (arrayList) {
                Iterator iterator = this._records.iterator();
                while (iterator.hasNext()) {
                    ProgressRecord progressRecord = (ProgressRecord)iterator.next();
                    d += progressRecord.getPercent() * progressRecord.getWeight();
                    d2 += progressRecord.getWeight();
                }
            }
            int n = (int)(d * 100.0 / d2);
            if (n > 100) {
                n = 100;
            }
            return n;
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._preloader != null) {
                try {
                    this._preloader.handleEvent((PreloaderEvent)new DownloadErrorEvent(uRL, string));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        }

        void jarDone(URL uRL) {
            String string;
            ProgressRecord progressRecord;
            if (this._preloader != null && (progressRecord = this.getProgressRecord(string = uRL.toString())) != null && progressRecord.getPercent() < 1.0) {
                progressRecord.markComplete();
                int n = this.getOverallPercent();
                try {
                    this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(1, uRL, null, null, (long)progressRecord.getCachedTotalElements(), (long)progressRecord.getCachedTotalElements(), n));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        }
    }

    private static class ProgressRecord {
        private String _url;
        private String _ver;
        private int _size;
        private double _percent;
        private int _totalElements = 1;
        private double _weight;

        public ProgressRecord(String string, String string2, int n) {
            this._url = string;
            this._ver = string2;
            this._size = n;
            this._weight = 1.0;
            this._percent = 0.0;
        }

        void cacheTotalElements(int n) {
            this._totalElements = n;
        }

        int getCachedTotalElements() {
            return this._totalElements;
        }

        void setWeight(double d) {
            this._weight = d;
        }

        void setSize(int n) {
            this._size = n;
        }

        double getPercent() {
            return this._percent;
        }

        String getUrl() {
            return this._url;
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + (this._url != null ? this._url.hashCode() : 0);
            return n;
        }

        public boolean equals(Object object) {
            return this._url.equals(((ProgressRecord)object)._url);
        }

        double getWeight() {
            return this._weight;
        }

        void downloadProgress(int n) {
            this._percent = this._size != 0 ? (double)n / (double)this._size * 0.8 : 0.8;
        }

        void patchProgress(int n) {
            this._percent = (double)n / 100.0 * 0.1 + 0.8;
        }

        void validateProgress(int n, int n2) {
            this._percent = n2 != 0 ? (double)n / (double)n2 * 0.05 + 0.9 : 0.95;
        }

        private void markComplete() {
            this._percent = 1.0;
        }
    }
}

