/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.xdg.BaseDir;
import com.sun.deploy.xml.BadTokenException;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.xdg.Menu;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

final class MenuDatabase {
    private static final String DEFAULT_JWS_MENU_NAME = "Java WebStart";
    private static MenuDatabase instance;
    private Menu rootMenu;

    static synchronized MenuDatabase getInstance() {
        if (instance == null) {
            instance = new MenuDatabase();
        }
        return instance;
    }

    MenuDatabase() {
        this.load();
    }

    private File getMenuFile() {
        BaseDir baseDir = BaseDir.getInstance();
        String string = baseDir.getUserConfigDir() + File.separatorChar + "menus" + File.separator + "applications-merged" + File.separator + "javaws.menu";
        return new File(string);
    }

    void load() {
        File file = this.getMenuFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            XMLParser xMLParser = new XMLParser(stringBuffer.toString());
            XMLNode xMLNode = xMLParser.parse();
            this.rootMenu = new Menu();
            this.rootMenu.read(xMLNode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.rootMenu = new Menu("Applications", null);
            Menu menu = new Menu(DEFAULT_JWS_MENU_NAME, this.rootMenu);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
        }
        catch (BadTokenException badTokenException) {
            Trace.ignored((Throwable)badTokenException);
        }
    }

    void save() throws IOException {
        File file = this.getMenuFile();
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        this.rootMenu.write(bufferedWriter);
        bufferedWriter.close();
    }

    private Menu getJavaWSMenu() {
        return this.rootMenu.getSubMenu(DEFAULT_JWS_MENU_NAME);
    }

    static boolean isJavaWSMenu(Menu menu) {
        return DEFAULT_JWS_MENU_NAME.equals(menu.getName());
    }

    Menu addMenu(String string) {
        return this.getJavaWSMenu().addMenuPath(string);
    }

    Menu getMenu(String string) {
        return this.getJavaWSMenu().getMenuPath(string);
    }
}

