/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.jaxws;

import com.sun.xml.internal.ws.api.policy.AlternativeSelector;
import com.sun.xml.internal.ws.api.policy.PolicyResolver;
import com.sun.xml.internal.ws.api.policy.ValidationProcessor;
import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.EffectivePolicyModifier;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.internal.ws.resources.PolicyMessages;
import javax.xml.ws.WebServiceException;

public class DefaultPolicyResolver
implements PolicyResolver {
    @Override
    public PolicyMap resolve(PolicyResolver.ServerContext serverContext) {
        PolicyMap policyMap = serverContext.getPolicyMap();
        if (policyMap != null) {
            this.validateServerPolicyMap(policyMap);
        }
        return policyMap;
    }

    @Override
    public PolicyMap resolve(PolicyResolver.ClientContext clientContext) {
        PolicyMap policyMap = clientContext.getPolicyMap();
        if (policyMap != null) {
            policyMap = this.doAlternativeSelection(policyMap);
        }
        return policyMap;
    }

    private void validateServerPolicyMap(PolicyMap policyMap) {
        try {
            ValidationProcessor validationProcessor = ValidationProcessor.getInstance();
            for (Policy policy : policyMap) {
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion policyAssertion : assertionSet) {
                        PolicyAssertionValidator.Fitness fitness = validationProcessor.validateServerSide(policyAssertion);
                        if (fitness == PolicyAssertionValidator.Fitness.SUPPORTED) continue;
                        throw new PolicyException(PolicyMessages.WSP_1015_SERVER_SIDE_ASSERTION_VALIDATION_FAILED(policyAssertion.getName(), (Object)fitness));
                    }
                }
            }
        }
        catch (PolicyException policyException) {
            throw new WebServiceException(policyException);
        }
    }

    private PolicyMap doAlternativeSelection(PolicyMap policyMap) {
        EffectivePolicyModifier effectivePolicyModifier = EffectivePolicyModifier.createEffectivePolicyModifier();
        effectivePolicyModifier.connect(policyMap);
        try {
            AlternativeSelector.doSelection(effectivePolicyModifier);
        }
        catch (PolicyException policyException) {
            throw new WebServiceException(policyException);
        }
        return policyMap;
    }
}

