/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import sun.security.ssl.Krb5Proxy;

public final class Krb5Helper {
    private static final String IMPL_CLASS = "sun.security.ssl.krb5.Krb5ProxyImpl";
    private static final Krb5Proxy proxy = AccessController.doPrivileged(new PrivilegedAction<Krb5Proxy>(){

        @Override
        public Krb5Proxy run() {
            try {
                Class<?> clazz = Class.forName(Krb5Helper.IMPL_CLASS, true, null);
                return (Krb5Proxy)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
    });

    private Krb5Helper() {
    }

    public static boolean isAvailable() {
        return proxy != null;
    }

    private static void ensureAvailable() {
        if (proxy == null) {
            throw new AssertionError((Object)"Kerberos should have been available");
        }
    }

    public static Subject getClientSubject(AccessControlContext accessControlContext) throws LoginException {
        Krb5Helper.ensureAvailable();
        return proxy.getClientSubject(accessControlContext);
    }

    public static Subject getServerSubject(AccessControlContext accessControlContext) throws LoginException {
        Krb5Helper.ensureAvailable();
        return proxy.getServerSubject(accessControlContext);
    }

    public static SecretKey[] getServerKeys(AccessControlContext accessControlContext) throws LoginException {
        Krb5Helper.ensureAvailable();
        return proxy.getServerKeys(accessControlContext);
    }

    public static String getServerPrincipalName(SecretKey secretKey) {
        Krb5Helper.ensureAvailable();
        return proxy.getServerPrincipalName(secretKey);
    }

    public static String getPrincipalHostName(Principal principal) {
        Krb5Helper.ensureAvailable();
        return proxy.getPrincipalHostName(principal);
    }

    public static Permission getServicePermission(String string, String string2) {
        Krb5Helper.ensureAvailable();
        return proxy.getServicePermission(string, string2);
    }
}

