/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.IllegalComponentStateException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionPropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class JComboBox<E>
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final String uiClassID = "ComboBoxUI";
    protected ComboBoxModel<E> dataModel;
    protected ListCellRenderer<? super E> renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected KeySelectionManager keySelectionManager = null;
    protected String actionCommand = "comboBoxChanged";
    protected boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
    protected Object selectedItemReminder = null;
    private E prototypeDisplayValue;
    private boolean firingActionEvent = false;
    private boolean selectingItem = false;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;

    public JComboBox(ComboBoxModel<E> comboBoxModel) {
        this.setModel(comboBoxModel);
        this.init();
    }

    public JComboBox(E[] EArray) {
        this.setModel(new DefaultComboBoxModel<E>(EArray));
        this.init();
    }

    public JComboBox(Vector<E> vector) {
        this.setModel(new DefaultComboBoxModel<E>(vector));
        this.init();
    }

    public JComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.init();
    }

    private void init() {
        this.installAncestorListener();
        this.setUIProperty("opaque", true);
        this.updateUI();
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (ancestorEvent.getSource() != JComboBox.this) {
                    JComboBox.this.hidePopup();
                }
            }
        });
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    @Override
    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
        ListCellRenderer<E> listCellRenderer = this.getRenderer();
        if (listCellRenderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)listCellRenderer));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel<E> comboBoxModel) {
        ComboBoxModel<E> comboBoxModel2 = this.dataModel;
        if (comboBoxModel2 != null) {
            comboBoxModel2.removeListDataListener(this);
        }
        this.dataModel = comboBoxModel;
        this.dataModel.addListDataListener(this);
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
    }

    public ComboBoxModel<E> getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        boolean bl2 = this.lightWeightPopupEnabled;
        this.lightWeightPopupEnabled = bl;
        this.firePropertyChange("lightWeightPopupEnabled", bl2, this.lightWeightPopupEnabled);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable;
        this.isEditable = bl;
        this.firePropertyChange("editable", bl2, this.isEditable);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer<? super E> listCellRenderer) {
        ListCellRenderer<? super E> listCellRenderer2 = this.renderer;
        this.renderer = listCellRenderer;
        this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        this.invalidate();
    }

    public ListCellRenderer<? super E> getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        ComboBoxEditor comboBoxEditor2 = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object object) {
        Object object2 = this.selectedItemReminder;
        Object object3 = object;
        if (object2 == null || !object2.equals(object)) {
            if (object != null && !this.isEditable()) {
                boolean bl = false;
                for (int i = 0; i < this.dataModel.getSize(); ++i) {
                    Object e = this.dataModel.getElementAt(i);
                    if (!object.equals(e)) continue;
                    bl = true;
                    object3 = e;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            this.selectingItem = true;
            this.dataModel.setSelectedItem(object3);
            this.selectingItem = false;
            if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
                this.selectedItemChanged();
            }
        }
        this.fireActionEvent();
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n));
        }
    }

    @Transient
    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = this.dataModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.dataModel.getElementAt(i);
            if (e == null || !e.equals(object)) continue;
            return i;
        }
        return -1;
    }

    public E getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    public void setPrototypeDisplayValue(E e) {
        E e2 = this.prototypeDisplayValue;
        this.prototypeDisplayValue = e;
        this.firePropertyChange("prototypeDisplayValue", e2, e);
    }

    public void addItem(E e) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(e);
    }

    public void insertItemAt(E e, int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(e, n);
    }

    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void removeItemAt(int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n);
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            for (int i = 0; i < n; ++i) {
                Object e = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(e);
            }
        }
        this.selectedItemReminder = null;
        if (this.isEditable()) {
            this.editor.setItem(null);
        }
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean bl) {
        this.getUI().setPopupVisible(this, bl);
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(ActionListener.class, actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(ActionListener.class, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
        }
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl = false;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != clazz || objectArray[i + 1] != actionListener) continue;
            bl = true;
        }
        return bl;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        AbstractAction.setEnabledFromAction(this, action);
        AbstractAction.setToolTipTextFromAction(this, action);
        this.setActionCommandFromAction(action);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new ComboBoxActionPropertyChangeListener(this, action);
    }

    protected void actionPropertyChanged(Action action, String string) {
        if (string == "ActionCommandKey") {
            this.setActionCommandFromAction(action);
        } else if (string == "enabled") {
            AbstractAction.setEnabledFromAction(this, action);
        } else if ("ShortDescription" == string) {
            AbstractAction.setToolTipTextFromAction(this, action);
        }
    }

    private void setActionCommandFromAction(Action action) {
        this.setActionCommand(action != null ? (String)action.getValue("ActionCommandKey") : null);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ItemListener.class) continue;
            ((ItemListener)objectArray[i + 1]).itemStateChanged(itemEvent);
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent actionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            long l = EventQueue.getMostRecentEventTime();
            int n = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n = ((ActionEvent)aWTEvent).getModifiers();
            }
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ActionListener.class) continue;
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, this.getActionCommand(), l, n);
                }
                ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
            }
            this.firingActionEvent = false;
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getEditor().getItem();
        this.setPopupVisible(false);
        this.getModel().setSelectedItem(object);
        String string = this.getActionCommand();
        this.setActionCommand("comboBoxEdited");
        this.fireActionEvent();
        this.setActionCommand(string);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        Object object = this.selectedItemReminder;
        Object object2 = this.dataModel.getSelectedItem();
        if (object == null || !object.equals(object2)) {
            this.selectedItemChanged();
            if (!this.selectingItem) {
                this.fireActionEvent();
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
            this.selectedItemChanged();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public boolean selectWithKeyChar(char c) {
        int n;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if ((n = this.keySelectionManager.selectionForKey(c, this.getModel())) != -1) {
            this.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.hidePopup();
        }
        super.processKeyEvent(keyEvent);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (super.processKeyBinding(keyStroke, keyEvent, n, bl)) {
            return true;
        }
        if (!this.isEditable() || n != 0 || this.getEditor() == null || !Boolean.TRUE.equals(this.getClientProperty("JComboBox.isTableCellEditor"))) {
            return false;
        }
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            return jComponent.processKeyBinding(keyStroke, keyEvent, 0, bl);
        }
        return false;
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public E getItemAt(int n) {
        return this.dataModel.getElementAt(n);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String string = this.selectedItemReminder != null ? this.selectedItemReminder.toString() : "";
        String string2 = this.isEditable ? "true" : "false";
        String string3 = this.lightWeightPopupEnabled ? "true" : "false";
        return super.paramString() + ",isEditable=" + string2 + ",lightWeightPopupEnabled=" + string3 + ",maximumRowCount=" + this.maximumRowCount + ",selectedItemReminder=" + string;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        private JList popupList;
        private Accessible previousSelectedAccessible;
        private javax.swing.JComboBox$AccessibleJComboBox.EditorAccessibleContext editorAccessibleContext;

        public AccessibleJComboBox() {
            super(JComboBox.this);
            this.previousSelectedAccessible = null;
            this.editorAccessibleContext = null;
            JComboBox.this.addPropertyChangeListener(new AccessibleJComboBoxPropertyChangeListener());
            this.setEditorNameAndDescription();
            Accessible accessible = JComboBox.this.getUI().getAccessibleChild(JComboBox.this, 0);
            if (accessible instanceof ComboPopup) {
                this.popupList = ((ComboPopup)((Object)accessible)).getList();
                this.popupList.addListSelectionListener(new AccessibleJComboBoxListSelectionListener());
            }
            JComboBox.this.addPopupMenuListener(new AccessibleJComboBoxPopupMenuListener());
        }

        private void setEditorNameAndDescription() {
            AccessibleContext accessibleContext;
            Component component;
            ComboBoxEditor comboBoxEditor = JComboBox.this.getEditor();
            if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) instanceof Accessible && (accessibleContext = component.getAccessibleContext()) != null) {
                accessibleContext.setAccessibleName(this.getAccessibleName());
                accessibleContext.setAccessibleDescription(this.getAccessibleDescription());
            }
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (JComboBox.this.ui != null) {
                return JComboBox.this.ui.getAccessibleChildrenCount(JComboBox.this);
            }
            return super.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (JComboBox.this.ui != null) {
                return JComboBox.this.ui.getAccessibleChild(JComboBox.this, n);
            }
            return super.getAccessibleChild(n);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (accessibleStateSet == null) {
                accessibleStateSet = new AccessibleStateSet();
            }
            if (JComboBox.this.isPopupVisible()) {
                accessibleStateSet.add(AccessibleState.EXPANDED);
            } else {
                accessibleStateSet.add(AccessibleState.COLLAPSED);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return UIManager.getString("ComboBox.togglePopupText");
            }
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                JComboBox.this.setPopupVisible(!JComboBox.this.isPopupVisible());
                return true;
            }
            return false;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            Object object = JComboBox.this.getSelectedItem();
            if (object != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            AccessibleSelection accessibleSelection;
            JList jList;
            AccessibleContext accessibleContext;
            Accessible accessible = JComboBox.this.getUI().getAccessibleChild(JComboBox.this, 0);
            if (accessible != null && accessible instanceof ComboPopup && (accessibleContext = (jList = ((ComboPopup)((Object)accessible)).getList()).getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                return accessibleSelection.getAccessibleSelection(n);
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return JComboBox.this.getSelectedIndex() == n;
        }

        @Override
        public void addAccessibleSelection(int n) {
            this.clearAccessibleSelection();
            JComboBox.this.setSelectedIndex(n);
        }

        @Override
        public void removeAccessibleSelection(int n) {
            if (JComboBox.this.getSelectedIndex() == n) {
                this.clearAccessibleSelection();
            }
        }

        @Override
        public void clearAccessibleSelection() {
            JComboBox.this.setSelectedIndex(-1);
        }

        @Override
        public void selectAllAccessibleSelection() {
        }

        private class AccessibleEditor
        implements Accessible {
            private AccessibleEditor() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                Component component;
                if (AccessibleJComboBox.this.editorAccessibleContext == null && (component = JComboBox.this.getEditor().getEditorComponent()) instanceof Accessible) {
                    AccessibleJComboBox.this.editorAccessibleContext = new EditorAccessibleContext((Accessible)((Object)component));
                }
                return AccessibleJComboBox.this.editorAccessibleContext;
            }
        }

        private class AccessibleJComboBoxListSelectionListener
        implements ListSelectionListener {
            private AccessibleJComboBoxListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PropertyChangeEvent propertyChangeEvent;
                if (AccessibleJComboBox.this.popupList == null) {
                    return;
                }
                int n = AccessibleJComboBox.this.popupList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                Accessible accessible = AccessibleJComboBox.this.popupList.getAccessibleContext().getAccessibleChild(n);
                if (accessible == null) {
                    return;
                }
                if (AccessibleJComboBox.this.previousSelectedAccessible != null) {
                    propertyChangeEvent = new PropertyChangeEvent(AccessibleJComboBox.this.previousSelectedAccessible, "AccessibleState", AccessibleState.FOCUSED, null);
                    AccessibleJComboBox.this.firePropertyChange("AccessibleState", null, propertyChangeEvent);
                }
                propertyChangeEvent = new PropertyChangeEvent(accessible, "AccessibleState", null, AccessibleState.FOCUSED);
                AccessibleJComboBox.this.firePropertyChange("AccessibleState", null, propertyChangeEvent);
                AccessibleJComboBox.this.firePropertyChange("AccessibleActiveDescendant", AccessibleJComboBox.this.previousSelectedAccessible, accessible);
                AccessibleJComboBox.this.previousSelectedAccessible = accessible;
            }
        }

        private class AccessibleJComboBoxPopupMenuListener
        implements PopupMenuListener {
            private AccessibleJComboBoxPopupMenuListener() {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                if (AccessibleJComboBox.this.popupList == null) {
                    return;
                }
                int n = AccessibleJComboBox.this.popupList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                AccessibleJComboBox.this.previousSelectedAccessible = AccessibleJComboBox.this.popupList.getAccessibleContext().getAccessibleChild(n);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        }

        private class AccessibleJComboBoxPropertyChangeListener
        implements PropertyChangeListener {
            private AccessibleJComboBoxPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "editor") {
                    AccessibleJComboBox.this.setEditorNameAndDescription();
                }
            }
        }

        private class EditorAccessibleContext
        extends AccessibleContext {
            private AccessibleContext ac;

            private EditorAccessibleContext() {
            }

            EditorAccessibleContext(Accessible accessible) {
                this.ac = accessible.getAccessibleContext();
            }

            @Override
            public String getAccessibleName() {
                return this.ac.getAccessibleName();
            }

            @Override
            public void setAccessibleName(String string) {
                this.ac.setAccessibleName(string);
            }

            @Override
            public String getAccessibleDescription() {
                return this.ac.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String string) {
                this.ac.setAccessibleDescription(string);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return this.ac.getAccessibleRole();
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                return this.ac.getAccessibleStateSet();
            }

            @Override
            public Accessible getAccessibleParent() {
                return this.ac.getAccessibleParent();
            }

            @Override
            public void setAccessibleParent(Accessible accessible) {
                this.ac.setAccessibleParent(accessible);
            }

            @Override
            public int getAccessibleIndexInParent() {
                return JComboBox.this.getSelectedIndex();
            }

            @Override
            public int getAccessibleChildrenCount() {
                return this.ac.getAccessibleChildrenCount();
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                return this.ac.getAccessibleChild(n);
            }

            @Override
            public Locale getLocale() throws IllegalComponentStateException {
                return this.ac.getLocale();
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.ac.addPropertyChangeListener(propertyChangeListener);
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.ac.removePropertyChangeListener(propertyChangeListener);
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this.ac.getAccessibleAction();
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this.ac.getAccessibleComponent();
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.ac.getAccessibleSelection();
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this.ac.getAccessibleText();
            }

            @Override
            public AccessibleEditableText getAccessibleEditableText() {
                return this.ac.getAccessibleEditableText();
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this.ac.getAccessibleValue();
            }

            @Override
            public AccessibleIcon[] getAccessibleIcon() {
                return this.ac.getAccessibleIcon();
            }

            @Override
            public AccessibleRelationSet getAccessibleRelationSet() {
                return this.ac.getAccessibleRelationSet();
            }

            @Override
            public AccessibleTable getAccessibleTable() {
                return this.ac.getAccessibleTable();
            }

            @Override
            public void firePropertyChange(String string, Object object, Object object2) {
                this.ac.firePropertyChange(string, object, object2);
            }
        }
    }

    private static class ComboBoxActionPropertyChangeListener
    extends ActionPropertyChangeListener<JComboBox<?>> {
        ComboBoxActionPropertyChangeListener(JComboBox<?> jComboBox, Action action) {
            super(jComboBox, action);
        }

        @Override
        protected void actionPropertyChanged(JComboBox<?> jComboBox, Action action, PropertyChangeEvent propertyChangeEvent) {
            if (AbstractAction.shouldReconfigure(propertyChangeEvent)) {
                jComboBox.configurePropertiesFromAction(action);
            } else {
                jComboBox.actionPropertyChanged(action, propertyChangeEvent.getPropertyName());
            }
        }
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        @Override
        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            String string;
            Object e;
            int n;
            int n2;
            int n3 = -1;
            Object object = comboBoxModel.getSelectedItem();
            if (object != null) {
                n2 = comboBoxModel.getSize();
                for (n = 0; n < n2; ++n) {
                    if (object != comboBoxModel.getElementAt(n)) continue;
                    n3 = n;
                    break;
                }
            }
            String string2 = ("" + c).toLowerCase();
            c = string2.charAt(0);
            n2 = comboBoxModel.getSize();
            for (n = ++n3; n < n2; ++n) {
                e = comboBoxModel.getElementAt(n);
                if (e == null || e.toString() == null || (string = e.toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            for (n = 0; n < n3; ++n) {
                e = comboBoxModel.getElementAt(n);
                if (e == null || e.toString() == null || (string = e.toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            return -1;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

