/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import sun.awt.AWTAutoShutdown;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.XSettings;
import sun.awt.motif.MFontPeer;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;
import sun.security.action.GetBooleanAction;
import sun.util.logging.PlatformLogger;

public class MToolkit
extends UNIXToolkit
implements Runnable {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.motif.MToolkit");
    protected static boolean dynamicLayoutSetting = false;
    private boolean loadedXSettings;
    private XSettings xs;
    static final X11GraphicsConfig config = GraphicsEnvironment.isHeadless() ? null : (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final boolean motifdnd = AccessController.doPrivileged(new GetBooleanAction("awt.dnd.motifdnd"));
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String dndPrefix = "DnD.";
    private static final long WORKAROUND_SLEEP = 100L;
    public static final int UNDETERMINED_WM = 1;
    public static final int NO_WM = 2;
    public static final int OTHER_WM = 3;
    public static final int OPENLOOK_WM = 4;
    public static final int MOTIF_WM = 5;
    public static final int CDE_WM = 6;
    public static final int ENLIGHTEN_WM = 7;
    public static final int KDE2_WM = 8;
    public static final int SAWFISH_WM = 9;
    public static final int ICE_WM = 10;
    public static final int METACITY_WM = 11;
    public static final int COMPIZ_WM = 12;
    public static final int LG3D_WM = 13;

    public MToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("MToolkit construction");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String string = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n = stackTraceElementArray.length - 1;
            if (n >= 0) {
                string = stackTraceElementArray[n].getClassName();
            }
            if (string == null || string.equals("")) {
                string = "AWT";
            }
            this.init(string);
            Thread thread = new Thread((Runnable)this, "AWT-Motif");
            thread.setPriority(6);
            thread.setDaemon(true);
            PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    Thread thread = new Thread(threadGroup, new Runnable(){

                        @Override
                        public void run() {
                            MToolkit.this.shutdown();
                        }
                    }, "Shutdown-Thread");
                    thread.setContextClassLoader(null);
                    Runtime.getRuntime().addShutdownHook(thread);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
            AWTAutoShutdown.notifyToolkitThreadBusy();
            thread.start();
        }
    }

    public native void init(String var1);

    @Override
    public native void run();

    private native void shutdown();

    @Override
    public ButtonPeer createButton(Button button) {
        return null;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        return null;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        return null;
    }

    @Override
    public ListPeer createList(List list) {
        return null;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        return null;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        return null;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        return null;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        return null;
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        return null;
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        return null;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        return null;
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        return null;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        return null;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        return null;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        return null;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        return null;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        return null;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        return null;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        return null;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        return null;
    }

    @Override
    public KeyboardFocusManagerPeer getKeyboardFocusManagerPeer() {
        return null;
    }

    @Override
    public FontPeer getFontPeer(String string, int n) {
        return new MFontPeer(string, n);
    }

    @Override
    public void setDynamicLayout(boolean bl) {
        dynamicLayoutSetting = bl;
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected native boolean isDynamicLayoutSupportedNative();

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupportedNative();
    }

    @Override
    public native boolean isFrameStateSupported(int var1);

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon trayIcon) throws HeadlessException {
        return null;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray systemTray) throws HeadlessException {
        return null;
    }

    @Override
    public boolean isTraySupported() {
        return false;
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    @Override
    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    @Override
    public native int getScreenResolution();

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected native int getScreenWidth();

    @Override
    protected native int getScreenHeight();

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return super.getFontMetrics(font);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, properties);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public native void beep();

    @Override
    public Clipboard getSystemClipboard() {
        return null;
    }

    @Override
    public Clipboard getSystemSelection() {
        return null;
    }

    @Override
    public boolean getLockingKeyState(int n) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(n);
    }

    public native boolean getLockingKeyStateNative(int var1);

    @Override
    public native void loadSystemColors(int[] var1);

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    protected static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    protected static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return null;
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        return null;
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return null;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return null;
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return null;
    }

    @Override
    public Dimension getBestCursorSize(int n, int n2) {
        return null;
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                System.err.println("cannot load system cursor: " + string2);
                return null;
            }
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            return this.lazilyLoadDynamicLayoutSupportedProperty(string);
        }
        if (!this.loadedXSettings && (string.startsWith("gnome.") || string.equals("awt.font.desktophints") || string.startsWith(dndPrefix))) {
            this.loadedXSettings = true;
            if (!GraphicsEnvironment.isHeadless()) {
                this.loadXSettings();
                this.desktopProperties.put("awt.font.desktophints", SunToolkit.getDesktopFontHints());
                return this.desktopProperties.get(string);
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    protected Boolean lazilyLoadDynamicLayoutSupportedProperty(String string) {
        boolean bl = this.isDynamicLayoutSupportedNative();
        if (log.isLoggable(400)) {
            log.finer("nativeDynamic == " + bl);
        }
        return bl;
    }

    private native int getMulticlickTime();

    @Override
    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", 50);
        this.desktopProperties.put("DnD.Autoscroll.interval", 50);
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", 5);
        if (!GraphicsEnvironment.isHeadless()) {
            this.desktopProperties.put("awt.multiClickInterval", this.getMulticlickTime());
            this.desktopProperties.put("awt.mouse.numButtons", this.getNumberOfButtons());
        }
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return null;
    }

    static boolean useMotifDnD() {
        return motifdnd;
    }

    private native void loadXSettings();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXSettings(int n, byte[] byArray) {
        Integer n2;
        Object object;
        Map map;
        if (this.xs == null) {
            this.xs = new XSettings();
        }
        if ((map = this.xs.update(byArray)) == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry object22 : map.entrySet()) {
            object = (String)object22.getKey();
            object = "gnome." + (String)object;
            this.setDesktopProperty((String)object, object22.getValue());
        }
        this.setDesktopProperty("awt.font.desktophints", SunToolkit.getDesktopFontHints());
        Object var5_6 = null;
        object = this;
        synchronized (object) {
            n2 = (Integer)this.desktopProperties.get("gnome.Net/DndDragThreshold");
        }
        if (n2 != null) {
            this.setDesktopProperty("DnD.gestureMotionThreshold", n2);
        }
    }

    @Override
    protected boolean needsXEmbedImpl() {
        return true;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.APPLICATION_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return modalExclusionType == Dialog.ModalExclusionType.NO_EXCLUDE;
    }

    private native boolean isSyncUpdated();

    private native boolean isSyncFailed();

    private native int getEventNumber();

    private native void updateSyncSelection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean syncNativeQueue(long l) {
        MToolkit.awtLock();
        try {
            long l2 = this.getEventNumber();
            this.updateSyncSelection();
            long l3 = System.currentTimeMillis();
            while (!this.isSyncUpdated() && !this.isSyncFailed()) {
                try {
                    MToolkit.awtLockWait(l);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                if (System.currentTimeMillis() - l3 <= l || l < 0L) continue;
                throw new SunToolkit.OperationTimedOut();
            }
            if (this.isSyncFailed() && (long)this.getEventNumber() - l2 == 1L) {
                MToolkit.awtUnlock();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                finally {
                    MToolkit.awtLock();
                }
            }
            boolean bl = (long)this.getEventNumber() - l2 > 2L;
            return bl;
        }
        finally {
            MToolkit.awtUnlock();
        }
    }

    @Override
    public void grab(Window window) {
        WindowPeer windowPeer = (WindowPeer)window.getPeer();
        if (windowPeer != null) {
            this.nativeGrab(windowPeer);
        }
    }

    @Override
    public void ungrab(Window window) {
        WindowPeer windowPeer = (WindowPeer)window.getPeer();
        if (windowPeer != null) {
            this.nativeUnGrab(windowPeer);
        }
    }

    private native void nativeGrab(WindowPeer var1);

    private native void nativeUnGrab(WindowPeer var1);

    @Override
    public boolean isDesktopSupported() {
        return false;
    }

    @Override
    public DesktopPeer createDesktopPeer(Desktop desktop) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    public static int getWMID() {
        String string = MToolkit.getWMName();
        if ("NO_WM".equals(string)) {
            return 2;
        }
        if ("OTHER_WM".equals(string)) {
            return 3;
        }
        if ("ENLIGHTEN_WM".equals(string)) {
            return 7;
        }
        if ("KDE2_WM".equals(string)) {
            return 8;
        }
        if ("SAWFISH_WM".equals(string)) {
            return 9;
        }
        if ("ICE_WM".equals(string)) {
            return 10;
        }
        if ("METACITY_WM".equals(string)) {
            return 11;
        }
        if ("OPENLOOK_WM".equals(string)) {
            return 4;
        }
        if ("MOTIF_WM".equals(string)) {
            return 5;
        }
        if ("CDE_WM".equals(string)) {
            return 6;
        }
        if ("COMPIZ_WM".equals(string)) {
            return 12;
        }
        if ("LG3D_WM".equals(string)) {
            return 13;
        }
        return 1;
    }

    private static native String getWMName();
}

