/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.ModbusSet;
import cn.com.voltronic.solar.dbtools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ModbusDao
extends BaseDao {
    public static final String INSERT_MODBUSSET = "insert into modbusset(portname,baudrate,databit,stopbit,parity,deviceid) values(?,?,?,?,?,?) ";
    public static final String QUERY_MODBUSSET_ALL = "select * from modbusset ";
    public static final String QUERY_MODBUSSET = "select * from modbusset where portname=? ";
    public static final String UPDATE_MODBUSSET = "update modbusset set baudrate=?,databit=?,stopbit=?,parity=?,deviceid=? where portname=? ";
    public static final String INSERT_MODBUSDEVICE = "insert into modbuspwd(serialno,password) values(?,?) ";
    public static final String QUERY_MODBUSDEVICE = "select password from modbuspwd where serialno = ? ";
    public static final String UPDATE_MODBUSDEVICE = "update modbuspwd set password=? where serialno=? ";

    public List<ModbusSet> queryModbusSet() {
        ArrayList<ModbusSet> result;
        block6: {
            result = new ArrayList<ModbusSet>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_MODBUSSET_ALL);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ModbusSet data = new ModbusSet();
                        data.setPortName(rs.getString("portname"));
                        data.setBaudrate(rs.getInt("baudrate"));
                        data.setDataBit(rs.getInt("databit"));
                        data.setStopBit(rs.getInt("stopbit"));
                        data.setParity(rs.getInt("parity"));
                        data.setDeviceIds(rs.getString("deviceid"));
                        result.add(data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public ModbusSet queryModbusSetByPort(String portName) {
        ModbusSet result;
        block6: {
            result = null;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_MODBUSSET);
                    ps.setString(1, portName);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = new ModbusSet();
                        result.setPortName(rs.getString("portname"));
                        result.setBaudrate(rs.getInt("baudrate"));
                        result.setDataBit(rs.getInt("databit"));
                        result.setStopBit(rs.getInt("stopbit"));
                        result.setParity(rs.getInt("parity"));
                        result.setDeviceIds(rs.getString("deviceid"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean addModbusSet(ModbusSet data) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_MODBUSSET);
                ps.setString(1, data.getPortName());
                ps.setInt(2, data.getBaudrate());
                ps.setInt(3, data.getDataBit());
                ps.setInt(4, data.getStopBit());
                ps.setInt(5, data.getParity());
                if (data.getDeviceIds().endsWith(",")) {
                    data.setDeviceIds(data.getDeviceIds().substring(0, data.getDeviceIds().length() - 1));
                }
                ps.setString(6, data.getDeviceIds());
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean updateModbusSet(ModbusSet data) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(UPDATE_MODBUSSET);
                ps.setInt(1, data.getBaudrate());
                ps.setInt(2, data.getDataBit());
                ps.setInt(3, data.getStopBit());
                ps.setInt(4, data.getParity());
                if (data.getDeviceIds().endsWith(",")) {
                    data.setDeviceIds(data.getDeviceIds().substring(0, data.getDeviceIds().length() - 1));
                }
                ps.setString(5, data.getDeviceIds());
                ps.setString(6, data.getPortName());
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public String queryModbusPassword(String serialno) {
        String result;
        block7: {
            result = "";
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERY_MODBUSDEVICE);
                        ps.setString(1, serialno);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            result = rs.getString("password");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    public boolean addModbusPassword(String serialno, String password) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_MODBUSDEVICE);
                ps.setString(1, serialno);
                ps.setString(2, password);
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean updateModbusPassword(String serialno, String password) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(UPDATE_MODBUSDEVICE);
                ps.setString(1, password);
                ps.setString(2, serialno);
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }
}

