/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generic;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBeanFactoryAccessor {
    private final ListableBeanFactory beanFactory;

    public GenericBeanFactoryAccessor(ListableBeanFactory listableBeanFactory) {
        Assert.notNull((Object)listableBeanFactory, (String)"Bean factory must not be null");
        this.beanFactory = listableBeanFactory;
    }

    public final ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public <T> T getBean(String string) throws BeansException {
        return (T)this.getBeanFactory().getBean(string);
    }

    public <T> T getBean(String string, Class<T> clazz) throws BeansException {
        return (T)this.getBeanFactory().getBean(string, clazz);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> clazz) throws BeansException {
        return this.getBeanFactory().getBeansOfType(clazz);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> clazz, boolean bl, boolean bl2) throws BeansException {
        return this.getBeanFactory().getBeansOfType(clazz, bl, bl2);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> clazz) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.getBeanFactory().getBeanNamesForType(null)) {
            Class clazz2 = this.getBeanFactory().getType(string);
            if (clazz2.getAnnotation(clazz) == null) continue;
            hashMap.put(string, this.getBeanFactory().getBean(string));
        }
        return hashMap;
    }
}

