/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.EmbedBlob;

class UpdatableBlobStream
extends InputStream {
    private boolean materialized;
    private InputStream stream;
    private long pos;
    private final EmbedBlob blob;
    private final long maxPos;

    UpdatableBlobStream(EmbedBlob embedBlob, InputStream inputStream) throws IOException {
        this(embedBlob, inputStream, 0L, Long.MAX_VALUE);
    }

    UpdatableBlobStream(EmbedBlob embedBlob, InputStream inputStream, long l, long l2) throws IOException {
        this.blob = embedBlob;
        this.stream = inputStream;
        this.maxPos = l + l2;
        if (l > 0L) {
            this.skip(l);
        }
    }

    private void updateIfRequired() throws IOException {
        if (this.materialized) {
            return;
        }
        if (this.blob.isMaterialized()) {
            long l;
            this.materialized = true;
            try {
                this.stream = this.blob.getBinaryStream();
            }
            catch (SQLException sQLException) {
                IOException iOException = new IOException(sQLException.getMessage());
                iOException.initCause(sQLException);
                throw iOException;
            }
            for (long i = this.pos; i > 0L; i -= l) {
                l = this.stream.skip(i);
                if (l != 0L) continue;
                if (this.stream.read() < 0) {
                    throw new IOException(MessageService.getCompleteMessage("XJ085.S", new Object[0]));
                }
                l = 1L;
            }
        }
    }

    public int read() throws IOException {
        this.updateIfRequired();
        if (this.pos >= this.maxPos) {
            return -1;
        }
        int n = this.stream.read();
        if (n >= 0) {
            ++this.pos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.updateIfRequired();
        int n3 = (int)Math.min((long)n2, this.maxPos - this.pos);
        int n4 = this.stream.read(byArray, n, n3);
        if (n4 > 0) {
            this.pos += (long)n4;
        }
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        this.updateIfRequired();
        int n = (int)Math.min((long)byArray.length, this.maxPos - this.pos);
        int n2 = this.stream.read(byArray, 0, n);
        if (n2 > 0) {
            this.pos += (long)n2;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        this.updateIfRequired();
        long l2 = this.stream.skip(l);
        if (l2 > 0L) {
            this.pos += l2;
        }
        return l2;
    }
}

