/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.xdg.MenuDatabase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

class Menu {
    private String name;
    private Menu parent;
    private ArrayList subMenus = new ArrayList();
    private ArrayList entries = new ArrayList();

    Menu() {
    }

    Menu(Menu menu) {
        this();
        this.parent = menu;
        if (menu != null) {
            menu.addSubMenu(this);
        }
    }

    Menu(String string, Menu menu) {
        this(menu);
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    private String[] splitPath(String string) {
        String string2;
        String string3;
        int n = string.indexOf(47);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
        } else {
            string3 = string;
            string2 = null;
        }
        return new String[]{string3, string2};
    }

    Menu addMenuPath(String string) {
        String[] stringArray = this.splitPath(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Menu menu = this.getSubMenu(string2);
        if (menu == null) {
            menu = new Menu(string2, this);
        }
        if (string3 != null) {
            return menu.addMenuPath(string3);
        }
        return menu;
    }

    Menu getMenuPath(String string) {
        String[] stringArray = this.splitPath(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Menu menu = this.getSubMenu(string2);
        if (string3 != null && menu != null) {
            return menu.addMenuPath(string3);
        }
        return menu;
    }

    Menu getSubMenu(String string) {
        Menu menu = null;
        Iterator iterator = this.subMenus.iterator();
        while (iterator.hasNext() && menu == null) {
            Menu menu2 = (Menu)iterator.next();
            if (!menu2.name.equals(string)) continue;
            menu = menu2;
        }
        return menu;
    }

    void addSubMenu(Menu menu) {
        if (!this.subMenus.contains(menu)) {
            this.subMenus.add(menu);
        }
    }

    void removeSubMenu(Menu menu) {
        this.subMenus.remove(menu);
        this.cleanupEmptyMenus();
    }

    void addEntry(String string) {
        this.entries.add(string);
    }

    void removeEntry(String string) {
        this.entries.remove(string);
        this.cleanupEmptyMenus();
    }

    private void cleanupEmptyMenus() {
        if (this.isEmpty() && this.parent != null && !MenuDatabase.isJavaWSMenu(this)) {
            this.parent.removeSubMenu(this);
        }
    }

    private boolean isEmpty() {
        return this.entries.size() == 0 && this.subMenus.size() == 0;
    }

    void write(Writer writer) throws IOException {
        Object object;
        writer.write("<Menu>\n");
        writer.write("<Name>" + this.name + "</Name>\n");
        Iterator iterator = this.subMenus.iterator();
        while (iterator.hasNext()) {
            object = (Menu)iterator.next();
            ((Menu)object).write(writer);
        }
        if (this.entries.size() > 0) {
            writer.write("<Include>\n");
            iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                writer.write("<Filename>" + (String)object + "</Filename>\n");
            }
            writer.write("</Include>\n");
        }
        writer.write("</Menu>\n");
    }

    void read(XMLNode xMLNode) {
        for (XMLNode xMLNode2 = xMLNode.getNested(); xMLNode2 != null; xMLNode2 = xMLNode2.getNext()) {
            Menu menu;
            if (xMLNode2.getName().equals("Menu")) {
                menu = new Menu(this);
                menu.read(xMLNode2);
                this.addSubMenu(menu);
                continue;
            }
            if (xMLNode2.getName().equals("Name")) {
                menu = xMLNode2.getNested();
                this.name = menu.getName();
                continue;
            }
            if (!xMLNode2.getName().equals("Include")) continue;
            for (menu = xMLNode2.getNested(); menu != null; menu = menu.getNext()) {
                XMLNode xMLNode3 = menu.getNested();
                this.addEntry(xMLNode3.getName());
            }
        }
    }
}

