/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.misc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import sun.misc.IOUtils;
import sun.reflect.misc.ReflectUtil;

public final class MethodUtil
extends SecureClassLoader {
    private static final String MISC_PKG = "sun.reflect.misc.";
    private static final String TRAMPOLINE = "sun.reflect.misc.Trampoline";
    private static final Method bounce = MethodUtil.getTrampoline();

    private MethodUtil() {
    }

    public static Method getMethod(Class<?> clazz, String string, Class[] classArray) throws NoSuchMethodException {
        ReflectUtil.checkPackageAccess(clazz);
        return clazz.getMethod(string, classArray);
    }

    public static Method[] getMethods(Class clazz) {
        ReflectUtil.checkPackageAccess(clazz);
        return clazz.getMethods();
    }

    public static Method[] getPublicMethods(Class clazz) {
        boolean bl;
        if (System.getSecurityManager() == null) {
            return clazz.getMethods();
        }
        HashMap<Signature, Method> hashMap = new HashMap<Signature, Method>();
        while (clazz != null && !(bl = MethodUtil.getInternalPublicMethods(clazz, hashMap))) {
            MethodUtil.getInterfaceMethods(clazz, hashMap);
            clazz = clazz.getSuperclass();
        }
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    private static void getInterfaceMethods(Class clazz, Map<Signature, Method> map) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            boolean bl = MethodUtil.getInternalPublicMethods(clazz2, map);
            if (bl) continue;
            MethodUtil.getInterfaceMethods(clazz2, map);
        }
    }

    private static boolean getInternalPublicMethods(Class clazz, Map<Signature, Method> map) {
        Class<?> clazz2;
        int n;
        Method[] methodArray = null;
        try {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return false;
            }
            if (!ReflectUtil.isPackageAccessible(clazz)) {
                return false;
            }
            methodArray = clazz.getMethods();
        }
        catch (SecurityException securityException) {
            return false;
        }
        boolean bl = true;
        for (n = 0; n < methodArray.length; ++n) {
            clazz2 = methodArray[n].getDeclaringClass();
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (n = 0; n < methodArray.length; ++n) {
                MethodUtil.addMethod(map, methodArray[n]);
            }
        } else {
            for (n = 0; n < methodArray.length; ++n) {
                clazz2 = methodArray[n].getDeclaringClass();
                if (!clazz.equals(clazz2)) continue;
                MethodUtil.addMethod(map, methodArray[n]);
            }
        }
        return bl;
    }

    private static void addMethod(Map<Signature, Method> map, Method method) {
        Method method2;
        Signature signature = new Signature(method);
        if (!map.containsKey(signature)) {
            map.put(signature, method);
        } else if (!method.getDeclaringClass().isInterface() && (method2 = map.get(signature)).getDeclaringClass().isInterface()) {
            map.put(signature, method);
        }
    }

    public static Object invoke(Method method, Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        try {
            return bounce.invoke(null, method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvocationTargetException) {
                throw (InvocationTargetException)throwable;
            }
            if (throwable instanceof IllegalAccessException) {
                throw (IllegalAccessException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("Unexpected invocation error", throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Unexpected invocation error", illegalAccessException);
        }
    }

    private static Method getTrampoline() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Class clazz = MethodUtil.getTrampolineClass();
                    Class[] classArray = new Class[]{Method.class, Object.class, Object[].class};
                    Method method = clazz.getDeclaredMethod("invoke", classArray);
                    method.setAccessible(true);
                    return method;
                }
            });
        }
        catch (Exception exception) {
            throw new InternalError("bouncer cannot be found");
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(string);
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.getParent().loadClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (!string.startsWith(MISC_PKG)) {
            throw new ClassNotFoundException(string);
        }
        String string2 = string.replace('.', '/').concat(".class");
        URL uRL = this.getResource(string2);
        if (uRL != null) {
            try {
                return this.defineClass(string, uRL);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string, iOException);
            }
        }
        throw new ClassNotFoundException(string);
    }

    private Class defineClass(String string, URL uRL) throws IOException {
        byte[] byArray = MethodUtil.getBytes(uRL);
        CodeSource codeSource = new CodeSource(null, (Certificate[])null);
        if (!string.equals(TRAMPOLINE)) {
            throw new IOException("MethodUtil: bad name " + string);
        }
        return this.defineClass(string, byArray, 0, byArray.length, codeSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL uRL) throws IOException {
        byte[] byArray;
        HttpURLConnection httpURLConnection;
        int n;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && (n = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
            throw new IOException("open HTTP connection failed.");
        }
        int n2 = uRLConnection.getContentLength();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());){
            byArray = IOUtils.readFully(bufferedInputStream, n2, true);
        }
        return byArray;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    private static Class getTrampolineClass() {
        try {
            return Class.forName(TRAMPOLINE, true, new MethodUtil());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static class Signature {
        private String methodName;
        private Class[] argClasses;
        private volatile int hashCode = 0;

        Signature(Method method) {
            this.methodName = method.getName();
            this.argClasses = method.getParameterTypes();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Signature signature = (Signature)object;
            if (!this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.argClasses.length != signature.argClasses.length) {
                return false;
            }
            for (int i = 0; i < this.argClasses.length; ++i) {
                if (this.argClasses[i] == signature.argClasses[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = 17;
                n = 37 * n + this.methodName.hashCode();
                if (this.argClasses != null) {
                    for (int i = 0; i < this.argClasses.length; ++i) {
                        n = 37 * n + (this.argClasses[i] == null ? 0 : this.argClasses[i].hashCode());
                    }
                }
                this.hashCode = n;
            }
            return this.hashCode;
        }
    }
}

