/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.beans.PropertyEditor;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    private int order = Integer.MAX_VALUE;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    private Map customEditors;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    static /* synthetic */ Class class$java$beans$PropertyEditor;

    public void setOrder(int n) {
        this.order = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrarArray) {
        this.propertyEditorRegistrars = propertyEditorRegistrarArray;
    }

    public void setCustomEditors(Map map) {
        this.customEditors = map;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        if (this.propertyEditorRegistrars != null) {
            for (int i = 0; i < this.propertyEditorRegistrars.length; ++i) {
                configurableListableBeanFactory.addPropertyEditorRegistrar(this.propertyEditorRegistrars[i]);
            }
        }
        if (this.customEditors != null) {
            Iterator iterator = this.customEditors.entrySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Class clazz = null;
                if (k instanceof Class) {
                    clazz = (Class)k;
                } else if (k instanceof String) {
                    string = (String)k;
                    clazz = ClassUtils.resolveClassName((String)string, (ClassLoader)this.beanClassLoader);
                } else {
                    throw new IllegalArgumentException("Invalid key [" + k + "] for custom editor: needs to be Class or String.");
                }
                string = entry.getValue();
                if (!(string instanceof PropertyEditor)) {
                    throw new IllegalArgumentException("Mapped value [" + string + "] for custom editor key [" + k + "] is not of required type [" + (class$java$beans$PropertyEditor == null ? (class$java$beans$PropertyEditor = CustomEditorConfigurer.class$("java.beans.PropertyEditor")) : class$java$beans$PropertyEditor).getName() + "]");
                }
                configurableListableBeanFactory.registerCustomEditor(clazz, (PropertyEditor)((Object)string));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

