/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesEditor
extends PropertyEditorSupport {
    private static final String COMMENT_MARKERS = "#!";

    public void setAsText(String string) throws IllegalArgumentException {
        Properties properties = new Properties();
        if (string != null) {
            try {
                properties.load(new ByteArrayInputStream(string.getBytes("ISO-8859-1")));
                this.dropComments(properties);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to parse [" + string + "] into Properties: " + iOException.getMessage());
            }
        }
        this.setValue(properties);
    }

    public void setValue(Object object) {
        if (!(object instanceof Properties) && object instanceof Map) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)object));
            super.setValue(properties);
        } else {
            super.setValue(object);
        }
    }

    private void dropComments(Properties properties) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.length() <= 0 || COMMENT_MARKERS.indexOf(string.charAt(0)) == -1) continue;
            iterator.remove();
        }
    }
}

