/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.ApplicationBase;
import com.sun.glass.ui.Clipboard;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Platform;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.utils.Disposer;
import com.sun.glass.utils.NativeLibLoader;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Application
extends ApplicationBase {
    private EventHandler eventHandler;
    private boolean initialActiveEventReceived = false;
    private String[] initialOpenedFiles = null;
    private static boolean loaded = false;
    private static Application application;
    private Thread eventThread;
    private static Map deviceDetails;
    private boolean terminateWhenLastWindowClosed = true;
    private static int nestedEventLoopCounter;

    public static synchronized void loadNativeLibrary(String string) {
        if (!loaded) {
            NativeLibLoader.loadLibrary(string);
            loaded = true;
        }
    }

    public static synchronized void loadNativeLibrary() {
        Application.loadNativeLibrary("glass");
    }

    public static void setDeviceDetails(Map map) {
        deviceDetails = map;
    }

    public static Map getDeviceDetails() {
        return deviceDetails;
    }

    public static void Run(String[] stringArray, String string, Launchable launchable) {
        System.err.println("com.sun.glass.ui.Application.Run(String args[], String title, final Launchable launchable) is deprecated and will go away soon");
        Application.Run(stringArray, launchable);
    }

    public static void Run(String[] stringArray, Launchable launchable) {
        Disposer.init();
        application = PlatformFactory.getPlatformFactory().createApplication();
        Application.application.platform = Platform.DeterminePlatform();
        Application.application.args = stringArray;
        Application.application.name = "java";
        Application.application.launchable = launchable;
        application.run();
    }

    private void run() {
        try {
            this.runLoop(this.args, this.launchable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected abstract void runLoop(String[] var1, Launchable var2);

    protected void finishTerminating() {
    }

    private void notifyWillFinishLaunching() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleWillFinishLaunchingAction(this, System.nanoTime());
        }
    }

    private void notifyDidFinishLaunching() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleDidFinishLaunchingAction(this, System.nanoTime());
        }
    }

    private void notifyWillBecomeActive() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleWillBecomeActiveAction(this, System.nanoTime());
        }
    }

    private void notifyDidBecomeActive() {
        this.initialActiveEventReceived = true;
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleDidBecomeActiveAction(this, System.nanoTime());
        }
    }

    private void notifyWillResignActive() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleWillResignActiveAction(this, System.nanoTime());
        }
    }

    private void notifyDidResignActive() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleDidResignActiveAction(this, System.nanoTime());
        }
    }

    private void notifyWillHide() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleWillHideAction(this, System.nanoTime());
        }
    }

    private void notifyDidHide() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleDidHideAction(this, System.nanoTime());
        }
    }

    private void notifyWillUnhide() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleWillUnhideAction(this, System.nanoTime());
        }
    }

    private void notifyDidUnhide() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleDidUnhideAction(this, System.nanoTime());
        }
    }

    private void notifyOpenFiles(String[] stringArray) {
        EventHandler eventHandler;
        if (!this.initialActiveEventReceived && this.initialOpenedFiles == null) {
            this.initialOpenedFiles = stringArray;
        }
        if ((eventHandler = this.getEventHandler()) != null && stringArray != null) {
            eventHandler.handleOpenFilesAction(this, System.nanoTime(), stringArray);
        }
    }

    private void notifyWillQuit() {
        EventHandler eventHandler = this.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleQuitAction(this, System.nanoTime());
        }
    }

    public void installDefaultMenus(MenuBar menuBar) {
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        boolean bl = this.eventHandler != null && this.initialOpenedFiles != null;
        this.eventHandler = eventHandler;
        if (bl) {
            this.notifyOpenFiles(this.initialOpenedFiles);
        }
    }

    public final boolean shouldTerminateWhenLastWindowClosed() {
        return this.terminateWhenLastWindowClosed;
    }

    public final void setTerminateWhenLastWindowClosed(boolean bl) {
        this.terminateWhenLastWindowClosed = bl;
    }

    public boolean shouldUpdateWindow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        try {
            Application application = this;
            synchronized (application) {
                Vector<Window> vector = new Vector<Window>(Window.getWindows());
                for (Window window : vector) {
                    window.setVisible(false);
                }
                for (Window window : vector) {
                    window.close();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.finishTerminating();
        }
    }

    public static Application GetApplication() {
        return application;
    }

    protected final void setEventThread(Thread thread) {
        this.eventThread = thread;
    }

    protected final Thread getEventThread() {
        return this.eventThread;
    }

    public static boolean checkEventThread(boolean bl, String string) {
        if (Thread.currentThread().equals(Application.GetApplication().getEventThread())) {
            return true;
        }
        if (bl) {
            throw new RuntimeException(string != null ? string : "This operation is permitted on the event thread only");
        }
        return false;
    }

    public static boolean checkEventThread(boolean bl) {
        return Application.checkEventThread(bl, null);
    }

    public static void checkEventThread() {
        Application.checkEventThread(true);
    }

    protected abstract void _invokeAndWait(Runnable var1);

    public static void invokeAndWait(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (Application.checkEventThread(false, "")) {
            runnable.run();
        } else {
            Application.GetApplication()._invokeAndWait(runnable);
        }
    }

    protected abstract void _invokeLater(Runnable var1);

    public static void invokeLater(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Application.GetApplication()._invokeLater(runnable);
    }

    protected abstract void _postOnEventQueue(Runnable var1);

    public static void postOnEventQueue(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Application.GetApplication()._postOnEventQueue(runnable);
    }

    protected abstract Object _enterNestedEventLoop();

    protected abstract void _leaveNestedEventLoop(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object enterNestedEventLoop() {
        Application.checkEventThread();
        ++nestedEventLoopCounter;
        try {
            Object object = Application.GetApplication()._enterNestedEventLoop();
            return object;
        }
        finally {
            --nestedEventLoopCounter;
        }
    }

    public static void leaveNestedEventLoop(Object object) {
        Application.checkEventThread();
        if (nestedEventLoopCounter == 0) {
            throw new IllegalStateException("Not in a nested event loop");
        }
        Application.GetApplication()._leaveNestedEventLoop(object);
    }

    public void menuAboutAction() {
        System.err.println("about");
    }

    public abstract Window createWindow(Window var1, Screen var2, int var3);

    public Window createWindow(Screen screen, int n) {
        return this.createWindow(null, screen, n);
    }

    public abstract Window createWindow(long var1);

    public abstract View createView(Pen var1);

    protected Clipboard createClipboard(String string) {
        return Clipboard.get(string);
    }

    public abstract Cursor createCursor(int var1);

    public abstract Cursor createCursor(int var1, int var2, Pixels var3);

    protected abstract void staticCursor_setVisible(boolean var1);

    protected abstract Size staticCursor_getBestSize(int var1, int var2);

    public Cursor createCursor(Pixels pixels) {
        return this.createCursor(pixels.getWidth() / 2, pixels.getHeight() / 2, pixels);
    }

    public Menu createMenu(String string) {
        return new Menu(string);
    }

    public Menu createMenu(String string, boolean bl) {
        return new Menu(string, bl);
    }

    public MenuBar createMenuBar() {
        return new MenuBar();
    }

    public MenuItem createMenuItem(String string) {
        return this.createMenuItem(string, null);
    }

    public MenuItem createMenuItem(String string, MenuItem.Callback callback) {
        return this.createMenuItem(string, callback, 0, 0);
    }

    public MenuItem createMenuItem(String string, MenuItem.Callback callback, int n, int n2) {
        return this.createMenuItem(string, callback, n, n2, null);
    }

    public MenuItem createMenuItem(String string, MenuItem.Callback callback, int n, int n2, Pixels pixels) {
        return new MenuItem(string, callback, n, n2, pixels);
    }

    public abstract Pixels createPixels(int var1, int var2, ByteBuffer var3);

    public abstract Pixels createPixels(int var1, int var2, IntBuffer var3);

    public abstract Pixels createPixels(int var1, int var2, IntBuffer var3, float var4);

    protected abstract int staticPixels_getNativeFormat();

    static Pixels createPixels(int n, int n2, int[] nArray, float f) {
        return Application.GetApplication().createPixels(n, n2, IntBuffer.wrap(nArray), f);
    }

    static float getScaleFactor(int n, int n2, int n3, int n4) {
        float f = 0.0f;
        for (Screen screen : Screen.getScreens()) {
            int n5 = screen.getX();
            int n6 = screen.getY();
            int n7 = screen.getWidth();
            int n8 = screen.getHeight();
            if (n >= n5 + n7 || n + n3 <= n5 || n2 >= n6 + n8 || n2 + n4 <= n6 || !(f < screen.getScale())) continue;
            f = screen.getScale();
        }
        return f == 0.0f ? 1.0f : f;
    }

    public abstract Robot createRobot();

    protected abstract Screen staticScreen_getDeepestScreen();

    protected abstract Screen staticScreen_getMainScreen();

    protected abstract Screen staticScreen_getScreenForLocation(int var1, int var2);

    protected abstract Screen staticScreen_getScreenForPtr(long var1);

    protected abstract List<Screen> staticScreen_getScreens();

    public abstract Timer createTimer(Runnable var1);

    protected abstract int staticTimer_getMinPeriod();

    protected abstract int staticTimer_getMaxPeriod();

    public final EventLoop createEventLoop() {
        return new EventLoop();
    }

    protected abstract List<File> staticCommonDialogs_showFileChooser(Window var1, String var2, String var3, String var4, int var5, boolean var6, CommonDialogs.ExtensionFilter[] var7);

    protected abstract File staticCommonDialogs_showFolderChooser(Window var1, String var2, String var3);

    protected abstract long staticView_getMultiClickTime();

    protected abstract int staticView_getMultiClickMaxX();

    protected abstract int staticView_getMultiClickMaxY();

    protected void staticView_notifyRenderingEnd() {
    }

    public abstract boolean supportsTransparentWindows();

    protected boolean _supportsSystemMenu() {
        return false;
    }

    public boolean supportsSystemMenu() {
        Application.checkEventThread();
        return this._supportsSystemMenu();
    }

    static {
        deviceDetails = null;
        nestedEventLoopCounter = 0;
    }

    public static class EventHandler {
        public void handleWillFinishLaunchingAction(Application application, long l) {
        }

        public void handleDidFinishLaunchingAction(Application application, long l) {
        }

        public void handleWillBecomeActiveAction(Application application, long l) {
        }

        public void handleDidBecomeActiveAction(Application application, long l) {
        }

        public void handleWillResignActiveAction(Application application, long l) {
        }

        public void handleDidResignActiveAction(Application application, long l) {
        }

        public void handleWillHideAction(Application application, long l) {
        }

        public void handleDidHideAction(Application application, long l) {
        }

        public void handleWillUnhideAction(Application application, long l) {
        }

        public void handleDidUnhideAction(Application application, long l) {
        }

        public void handleOpenFilesAction(Application application, long l, String[] stringArray) {
        }

        public void handleQuitAction(Application application, long l) {
        }
    }
}

