/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DelegatingEntityResolver
implements EntityResolver {
    public static final String DTD_SUFFIX = ".dtd";
    public static final String XSD_SUFFIX = ".xsd";
    private final EntityResolver dtdResolver;
    private final EntityResolver schemaResolver;

    public DelegatingEntityResolver(ClassLoader classLoader) {
        this.dtdResolver = new BeansDtdResolver();
        this.schemaResolver = new PluggableSchemaResolver(classLoader);
    }

    public DelegatingEntityResolver(EntityResolver entityResolver, EntityResolver entityResolver2) {
        Assert.notNull((Object)entityResolver);
        Assert.notNull((Object)entityResolver2);
        this.dtdResolver = entityResolver;
        this.schemaResolver = entityResolver2;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string2 != null) {
            if (string2.endsWith(DTD_SUFFIX)) {
                return this.dtdResolver.resolveEntity(string, string2);
            }
            if (string2.endsWith(XSD_SUFFIX)) {
                return this.schemaResolver.resolveEntity(string, string2);
            }
        }
        return null;
    }
}

