/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanDefinitionReaderUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";

    public static AbstractBeanDefinition createBeanDefinition(String string, String string2, ConstructorArgumentValues constructorArgumentValues, MutablePropertyValues mutablePropertyValues, ClassLoader classLoader) throws ClassNotFoundException {
        AbstractBeanDefinition abstractBeanDefinition = BeanDefinitionReaderUtils.createBeanDefinition(string2, string, classLoader);
        abstractBeanDefinition.setConstructorArgumentValues(constructorArgumentValues);
        abstractBeanDefinition.setPropertyValues(mutablePropertyValues);
        return abstractBeanDefinition;
    }

    public static AbstractBeanDefinition createBeanDefinition(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        AbstractBeanDefinition abstractBeanDefinition = null;
        abstractBeanDefinition = string != null ? new ChildBeanDefinition(string) : new RootBeanDefinition();
        if (string2 != null) {
            if (classLoader != null) {
                abstractBeanDefinition.setBeanClass(ClassUtils.forName((String)string2, (ClassLoader)classLoader));
            } else {
                abstractBeanDefinition.setBeanClassName(string2);
            }
        }
        return abstractBeanDefinition;
    }

    public static String generateBeanName(AbstractBeanDefinition abstractBeanDefinition, BeanDefinitionRegistry beanDefinitionRegistry, boolean bl) throws BeanDefinitionStoreException {
        String string = abstractBeanDefinition.getBeanClassName();
        if (string == null) {
            if (abstractBeanDefinition instanceof ChildBeanDefinition) {
                string = ((ChildBeanDefinition)abstractBeanDefinition).getParentName() + "$child";
            } else if (abstractBeanDefinition.getFactoryBeanName() != null) {
                string = abstractBeanDefinition.getFactoryBeanName() + "$created";
            }
        }
        if (!StringUtils.hasText((String)string)) {
            throw new BeanDefinitionStoreException("Unnamed bean definition specifies neither 'class' nor 'parent' nor 'factory-bean' - can't generate bean name");
        }
        String string2 = string;
        if (bl) {
            string2 = string + GENERATED_BEAN_NAME_SEPARATOR + ObjectUtils.getIdentityHexString((Object)abstractBeanDefinition);
        } else {
            int n = 0;
            while (beanDefinitionRegistry.containsBeanDefinition(string2)) {
                string2 = string + GENERATED_BEAN_NAME_SEPARATOR + ++n;
            }
        }
        return string2;
    }

    public static String generateBeanName(AbstractBeanDefinition abstractBeanDefinition, BeanDefinitionRegistry beanDefinitionRegistry) throws BeanDefinitionStoreException {
        return BeanDefinitionReaderUtils.generateBeanName(abstractBeanDefinition, beanDefinitionRegistry, false);
    }

    public static void registerBeanDefinition(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry) throws BeanDefinitionStoreException {
        String string = beanDefinitionHolder.getBeanName();
        beanDefinitionRegistry.registerBeanDefinition(string, beanDefinitionHolder.getBeanDefinition());
        String[] stringArray = beanDefinitionHolder.getAliases();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                beanDefinitionRegistry.registerAlias(string, stringArray[i]);
            }
        }
    }

    public static String registerWithGeneratedName(AbstractBeanDefinition abstractBeanDefinition, BeanDefinitionRegistry beanDefinitionRegistry) throws BeanDefinitionStoreException {
        String string = BeanDefinitionReaderUtils.generateBeanName(abstractBeanDefinition, beanDefinitionRegistry, false);
        beanDefinitionRegistry.registerBeanDefinition(string, abstractBeanDefinition);
        return string;
    }
}

