/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.jdkevents;

import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.Producer;
import com.sun.xml.internal.ws.org.objectweb.asm.ClassReader;
import com.sun.xml.internal.ws.org.objectweb.asm.ClassVisitor;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.jfr.events.ErrorThrownEvent;
import jdk.internal.jfr.events.ExceptionThrownEvent;
import jdk.internal.jfr.events.ThrowablesEvent;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.jdkevents.throwabletransform.ConstructorTracerWriter;

public final class ThrowableTracer {
    private static EventToken exceptionThrownToken;
    private static EventToken errorThrownToken;
    private static AtomicLong numThrowables;

    public static void enable(JFR jFR, Producer producer) throws Exception {
        exceptionThrownToken = producer.addEvent(ExceptionThrownEvent.class);
        errorThrownToken = producer.addEvent(ErrorThrownEvent.class);
        producer.addEvent(ThrowablesEvent.class);
    }

    public static void traceError(Error error, String string) {
        if (error instanceof OutOfMemoryError) {
            return;
        }
        ErrorThrownEvent errorThrownEvent = new ErrorThrownEvent(errorThrownToken);
        errorThrownEvent.message = string;
        errorThrownEvent.thrownClass = error.getClass();
        errorThrownEvent.commit();
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent(exceptionThrownToken);
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = error.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    public static void traceThrowable(Throwable throwable, String string) {
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent(exceptionThrownToken);
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = throwable.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    public static byte[] generateThrowableAsm() throws Exception {
        InputStream inputStream = ThrowableTracer.class.getResourceAsStream("/java/lang/Throwable.class");
        ClassReader classReader = new ClassReader(inputStream);
        ConstructorTracerWriter constructorTracerWriter = new ConstructorTracerWriter(1, Throwable.class);
        classReader.accept((ClassVisitor)constructorTracerWriter, 0);
        return constructorTracerWriter.toByteArray();
    }

    public static byte[] generateErrorAsm() throws Exception {
        InputStream inputStream = ThrowableTracer.class.getResourceAsStream("/java/lang/Error.class");
        ClassReader classReader = new ClassReader(inputStream);
        ConstructorTracerWriter constructorTracerWriter = new ConstructorTracerWriter(1, Error.class);
        classReader.accept((ClassVisitor)constructorTracerWriter, 0);
        return constructorTracerWriter.toByteArray();
    }

    public static long numThrowables() {
        return numThrowables.get();
    }

    static {
        numThrowables = new AtomicLong(0L);
    }
}

