/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public final class InvokeLaterDispatcher
extends Thread {
    private final BlockingDeque<Runnable> deque = new LinkedBlockingDeque<Runnable>();
    private final InvokeLaterLock LOCK = new InvokeLaterLock();
    private boolean nestedEventLoopEntered = false;
    private volatile boolean leavingNestedEventLoop = false;
    private final InvokeLaterSubmitter invokeLaterSubmitter;

    public InvokeLaterDispatcher(InvokeLaterSubmitter invokeLaterSubmitter) {
        this.setDaemon(true);
        this.invokeLaterSubmitter = invokeLaterSubmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Object object;
                Runnable runnable = this.deque.takeFirst();
                if (this.leavingNestedEventLoop) {
                    this.deque.addFirst(runnable);
                    object = this.LOCK;
                    synchronized (object) {
                        while (this.leavingNestedEventLoop) {
                            this.LOCK.wait();
                        }
                        continue;
                    }
                }
                object = new Future(runnable);
                this.invokeLaterSubmitter.submitForLaterInvocation((Runnable)object);
                InvokeLaterLock invokeLaterLock = this.LOCK;
                synchronized (invokeLaterLock) {
                    try {
                        while (!((Future)object).isDone() && !this.nestedEventLoopEntered) {
                            this.LOCK.wait();
                        }
                    }
                    finally {
                        this.nestedEventLoopEntered = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void invokeLater(Runnable runnable) {
        this.deque.addLast(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEnteringNestedEventLoop() {
        InvokeLaterLock invokeLaterLock = this.LOCK;
        synchronized (invokeLaterLock) {
            this.nestedEventLoopEntered = true;
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyLeavingNestedEventLoop() {
        InvokeLaterLock invokeLaterLock = this.LOCK;
        synchronized (invokeLaterLock) {
            this.leavingNestedEventLoop = true;
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyLeftNestedEventLoop() {
        InvokeLaterLock invokeLaterLock = this.LOCK;
        synchronized (invokeLaterLock) {
            this.leavingNestedEventLoop = false;
            this.LOCK.notifyAll();
        }
    }

    private class Future
    implements Runnable {
        private boolean done = false;
        private final Runnable runnable;

        public Future(Runnable runnable) {
            this.runnable = runnable;
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.runnable.run();
            InvokeLaterLock invokeLaterLock = InvokeLaterDispatcher.this.LOCK;
            synchronized (invokeLaterLock) {
                this.done = true;
                InvokeLaterDispatcher.this.LOCK.notifyAll();
            }
        }
    }

    private static final class InvokeLaterLock {
        private InvokeLaterLock() {
        }
    }

    public static interface InvokeLaterSubmitter {
        public void submitForLaterInvocation(Runnable var1);
    }
}

