/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P18;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class P181TO2K
extends P18
implements IProtocol {
    public Logger logger = Logger.getLogger(P181TO2K.class);
    protected String modelType = "01";
    protected int outputMode = 0;

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            IComUSBHandler _handler = (IComUSBHandler)handler;
            return this.doComUSB(_handler);
        }
        return false;
    }

    private boolean doComUSB(IComUSBHandler handler) {
        handler.setUseCRC(true);
        String qPI = handler.excuteSimpleCommand("PI");
        if (StringUtils.isEmpty((String)qPI) || !qPI.startsWith("18")) {
            return false;
        }
        String qID = handler.getSerialNo();
        if (StringUtils.isEmpty((String)qID)) {
            return false;
        }
        this.serialNo = qID;
        String pPIRI = handler.excuteCommand("PIRI", true);
        if (StringUtils.isEmpty((String)pPIRI)) {
            return false;
        }
        String[] piri = pPIRI.split(",");
        this.outputMode = VolUtil.parseInt(piri[22]);
        int acOutputRatingApparentPower = VolUtil.parseInt(piri[5]);
        return acOutputRatingApparentPower < 3000;
    }

    @Override
    public String getProtocolID() {
        return "P1812K";
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower[:]", "{workInfo.getPvInputPower1}", "W"));
        item.add(new AutoLabelItem("message.gridVoltageR[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        item.add(new AutoLabelItem("message.BatteryChargingCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        item.add(new AutoLabelItem("message.BatteryDischargeCurrent[:]", "{workInfo.getDisChargingCurrent}", "A"));
        item.add(new AutoLabelItem("message.gridOutputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.acOutputFreq[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.acOutputApperentPower[:]", "{workInfo.getAcOutputApperentPowerR}", "VA"));
        item.add(new AutoLabelItem("message.acOutputActivePower[:]", "{workInfo.getAcOutputActivePowerR}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputPower", "{workInfo.getPvInputPower1}", 3000.0, "W", true));
        list.add(new HistoryChart("message.gridVoltageR", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getBatteryVoltage}", 100.0, "V", true));
        list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
        list.add(new HistoryChart("message.BatteryChargingCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        list.add(new HistoryChart("message.BatteryDischargeCurrent", "{workInfo.getDisChargingCurrent}", 150.0, "A", true));
        list.add(new HistoryChart("message.gridOutputVoltage", "{workInfo.getAcOutputVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.acOutputFreq", "{workInfo.getAcOutputFrequency}", 70.0, "Hz", true));
        list.add(new HistoryChart("message.acOutputActivePower", "{workInfo.getAcOutputActivePowerR}", 3000.0, "VA", true));
        list.add(new HistoryChart("message.acOutputApperentPower", "{workInfo.getAcOutputApperentPowerR}", 3000.0, "W", true));
        list.add(new HistoryChart("message.loadpercent", "{workInfo.getOutputLoadPercent}", 100.0, "%", true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputPower", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{workInfo.getGridVoltageR}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{workInfo.getGridFrequency}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{workInfo.getBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
        list.add(new HistoryData("message.BatteryChargingCurrent", "{workInfo.getChargingCurrent}", true, true));
        list.add(new HistoryData("message.BatteryDischargeCurrent", "{workInfo.getDisChargingCurrent}", true, true));
        list.add(new HistoryData("message.gridOutputVoltage", "{workInfo.getAcOutputVoltageR}", true, true));
        list.add(new HistoryData("message.acOutputFreq", "{workInfo.getAcOutputFrequency}", true, true));
        list.add(new HistoryData("message.acOutputActivePower", "{workInfo.getAcOutputActivePowerR}", true, true));
        list.add(new HistoryData("message.acOutputApperentPower", "{workInfo.getAcOutputApperentPowerR}", true, true));
        list.add(new HistoryData("message.loadpercent", "{workInfo.getOutputLoadPercent}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.pvInputVoltage", "{faultData.getPvinputvoltage1}", true, true));
        list.add(new HistoryData("message.pvInputPower", "{faultData.getPvinputpower1}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{faultData.getGridVoltage}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{faultData.getGridFrequency}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{faultData.getBatteryVoltage}", true, true));
        list.add(new HistoryData("message.BatteryChargingCurrent", "{faultData.getBatteryChargingCurrent}", true, true));
        list.add(new HistoryData("message.BatteryDischargeCurrent", "{faultData.getBatteryDischargeCurrent}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{faultData.getBatteryCapacity}", true, true));
        list.add(new HistoryData("message.gridOutputVoltage", "{faultData.getAcoutputvoltager}", true, true));
        list.add(new HistoryData("message.acOutputFreq", "{faultData.getAcoutputfrequency}", true, true));
        list.add(new HistoryData("message.acOutputActivePower", "{faultData.getAcoutputactivepowerr}", true, true));
        list.add(new HistoryData("message.acOutputApperentPower", "{faultData.getAcoutputapperentpowerr}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.mainfirewareversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.slavefirewareversion[:]", "{machineInfo.getSlaveFirmwareVersion1}", ""));
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        ConfigData config = null;
        config = processor != null ? (ConfigData)processor.getBeanBag().getBean("configdata") : new ConfigData();
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        list.add(new AutoComboBoxItem("message.standard[:]", new String[]{"India", "Germany", "South America"}, "{configData.getRegulationsState}", "", "setRS", 0, false));
        list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Solar and Utility", "Solar only"}, "{configData.getChargerSourcePriority}", "", "setPCP", 0, false));
        list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargingCurrentComBox(), "{configData.getMaxChargingCurrent}", "A", "setMCHGC", 0, false));
        list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getMaxAcChargingCurrentCombox(), "{configData.getMaxAcChargingCurrent}", "A", "setMUCHGC", 0, false));
        list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getInputVoltageRange}", "", "setPGR", 0, false));
        list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "setPBT", 0, false));
        list.add(new AutoComboBoxItem("message.SolarPowerPriority[:]", new String[]{"Battery-Load-Utility", "Load-Battery-Utility"}, "{configData.getSolarPowerPriority}", "", "setPSP", 0, false));
        list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Solar-Utility-Battery", "Solar-Battery-Utility"}, "{configData.getOutputSourcePriority}", "", "setPOP", 0, false));
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50.0", "60.0"}, "{configData.getAcOutputRatingFrequency}", "Hz", "setF", 0, false));
        if (config.getAcOutputRatingVoltage() == 101.0 || config.getAcOutputRatingVoltage() == 110.0 || config.getAcOutputRatingVoltage() == 120.0) {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"101", "110", "120"}, "{configData.getAcOutputRatingVoltage}", "V", "setV", 0, false));
        } else {
            list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220.0", "230.0", "240.0"}, "{configData.getAcOutputRatingVoltage}", "V", "setV", 0, false));
        }
        if (config.getBatteryRatingVoltage() > 40.0) {
            list.add(new AutoComboBoxItem("message.BatteryRechargeVoltage[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getBatteryRechargeVoltage}", "V", "setBUCD", 0, false));
            list.add(new AutoComboBoxItem("message.BatteryRedischargeVoltage[:]", new String[]{"FULL", "48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0"}, "{configData.getBatteryRedischargeVoltage}", "V", "setBUCD", 1, false));
        } else if (config.getBatteryRatingVoltage() > 20.0) {
            list.add(new AutoComboBoxItem("message.BatteryRechargeVoltage[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getBatteryRechargeVoltage}", "V", "setBUCD", 0, false));
            list.add(new AutoComboBoxItem("message.BatteryRedischargeVoltage[:]", new String[]{"FULL", "24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5", "29.0"}, "{configData.getBatteryRedischargeVoltage}", "V", "setBUCD", 1, false));
        } else {
            list.add(new AutoComboBoxItem("message.BatteryRechargeVoltage[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getBatteryRechargeVoltage}", "V", "setBUCD", 0, false));
            list.add(new AutoComboBoxItem("message.BatteryRedischargeVoltage[:]", new String[]{"FULL", "12.0", "12.3", "12.5", "12.8", "13.0", "13.3", "13.5", "13.8", "14.0", "14.3", "14.5"}, "{configData.getBatteryRedischargeVoltage}", "V", "setBUCD", 1, false));
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }
}

