/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.tool.util;

import java.io.ByteArrayOutputStream;

public class CRCUtil {
    private static char[] crc_tb;
    private static String hexString;

    static {
        char[] cArray = new char[256];
        cArray[1] = 4129;
        cArray[2] = 8258;
        cArray[3] = 12387;
        cArray[4] = 16516;
        cArray[5] = 20645;
        cArray[6] = 24774;
        cArray[7] = 28903;
        cArray[8] = 33032;
        cArray[9] = 37161;
        cArray[10] = 41290;
        cArray[11] = 45419;
        cArray[12] = 49548;
        cArray[13] = 53677;
        cArray[14] = 57806;
        cArray[15] = 61935;
        cArray[16] = 4657;
        cArray[17] = 528;
        cArray[18] = 12915;
        cArray[19] = 8786;
        cArray[20] = 21173;
        cArray[21] = 17044;
        cArray[22] = 29431;
        cArray[23] = 25302;
        cArray[24] = 37689;
        cArray[25] = 33560;
        cArray[26] = 45947;
        cArray[27] = 41818;
        cArray[28] = 54205;
        cArray[29] = 50076;
        cArray[30] = 62463;
        cArray[31] = 58334;
        cArray[32] = 9314;
        cArray[33] = 13379;
        cArray[34] = 1056;
        cArray[35] = 5121;
        cArray[36] = 25830;
        cArray[37] = 29895;
        cArray[38] = 17572;
        cArray[39] = 21637;
        cArray[40] = 42346;
        cArray[41] = 46411;
        cArray[42] = 34088;
        cArray[43] = 38153;
        cArray[44] = 58862;
        cArray[45] = 62927;
        cArray[46] = 50604;
        cArray[47] = 54669;
        cArray[48] = 13907;
        cArray[49] = 9842;
        cArray[50] = 5649;
        cArray[51] = 1584;
        cArray[52] = 30423;
        cArray[53] = 26358;
        cArray[54] = 22165;
        cArray[55] = 18100;
        cArray[56] = 46939;
        cArray[57] = 42874;
        cArray[58] = 38681;
        cArray[59] = 34616;
        cArray[60] = 63455;
        cArray[61] = 59390;
        cArray[62] = 55197;
        cArray[63] = 51132;
        cArray[64] = 18628;
        cArray[65] = 22757;
        cArray[66] = 26758;
        cArray[67] = 30887;
        cArray[68] = 2112;
        cArray[69] = 6241;
        cArray[70] = 10242;
        cArray[71] = 14371;
        cArray[72] = 51660;
        cArray[73] = 55789;
        cArray[74] = 59790;
        cArray[75] = 63919;
        cArray[76] = 35144;
        cArray[77] = 39273;
        cArray[78] = 43274;
        cArray[79] = 47403;
        cArray[80] = 23285;
        cArray[81] = 19156;
        cArray[82] = 31415;
        cArray[83] = 27286;
        cArray[84] = 6769;
        cArray[85] = 2640;
        cArray[86] = 14899;
        cArray[87] = 10770;
        cArray[88] = 56317;
        cArray[89] = 52188;
        cArray[90] = 64447;
        cArray[91] = 60318;
        cArray[92] = 39801;
        cArray[93] = 35672;
        cArray[94] = 47931;
        cArray[95] = 43802;
        cArray[96] = 27814;
        cArray[97] = 31879;
        cArray[98] = 19684;
        cArray[99] = 23749;
        cArray[100] = 11298;
        cArray[101] = 15363;
        cArray[102] = 3168;
        cArray[103] = 7233;
        cArray[104] = 60846;
        cArray[105] = 64911;
        cArray[106] = 52716;
        cArray[107] = 56781;
        cArray[108] = 44330;
        cArray[109] = 48395;
        cArray[110] = 36200;
        cArray[111] = 40265;
        cArray[112] = 32407;
        cArray[113] = 28342;
        cArray[114] = 24277;
        cArray[115] = 20212;
        cArray[116] = 15891;
        cArray[117] = 11826;
        cArray[118] = 7761;
        cArray[119] = 3696;
        cArray[120] = 65439;
        cArray[121] = 61374;
        cArray[122] = 57309;
        cArray[123] = 53244;
        cArray[124] = 48923;
        cArray[125] = 44858;
        cArray[126] = 40793;
        cArray[127] = 36728;
        cArray[128] = 37256;
        cArray[129] = 33193;
        cArray[130] = 45514;
        cArray[131] = 41451;
        cArray[132] = 53516;
        cArray[133] = 49453;
        cArray[134] = 61774;
        cArray[135] = 57711;
        cArray[136] = 4224;
        cArray[137] = 161;
        cArray[138] = 12482;
        cArray[139] = 8419;
        cArray[140] = 20484;
        cArray[141] = 16421;
        cArray[142] = 28742;
        cArray[143] = 24679;
        cArray[144] = 33721;
        cArray[145] = 37784;
        cArray[146] = 41979;
        cArray[147] = 46042;
        cArray[148] = 49981;
        cArray[149] = 54044;
        cArray[150] = 58239;
        cArray[151] = 62302;
        cArray[152] = 689;
        cArray[153] = 4752;
        cArray[154] = 8947;
        cArray[155] = 13010;
        cArray[156] = 16949;
        cArray[157] = 21012;
        cArray[158] = 25207;
        cArray[159] = 29270;
        cArray[160] = 46570;
        cArray[161] = 42443;
        cArray[162] = 38312;
        cArray[163] = 34185;
        cArray[164] = 62830;
        cArray[165] = 58703;
        cArray[166] = 54572;
        cArray[167] = 50445;
        cArray[168] = 13538;
        cArray[169] = 9411;
        cArray[170] = 5280;
        cArray[171] = 1153;
        cArray[172] = 29798;
        cArray[173] = 25671;
        cArray[174] = 21540;
        cArray[175] = 17413;
        cArray[176] = 42971;
        cArray[177] = 47098;
        cArray[178] = 34713;
        cArray[179] = 38840;
        cArray[180] = 59231;
        cArray[181] = 63358;
        cArray[182] = 50973;
        cArray[183] = 55100;
        cArray[184] = 9939;
        cArray[185] = 14066;
        cArray[186] = 1681;
        cArray[187] = 5808;
        cArray[188] = 26199;
        cArray[189] = 30326;
        cArray[190] = 17941;
        cArray[191] = 22068;
        cArray[192] = 55628;
        cArray[193] = 51565;
        cArray[194] = 63758;
        cArray[195] = 59695;
        cArray[196] = 39368;
        cArray[197] = 35305;
        cArray[198] = 47498;
        cArray[199] = 43435;
        cArray[200] = 22596;
        cArray[201] = 18533;
        cArray[202] = 30726;
        cArray[203] = 26663;
        cArray[204] = 6336;
        cArray[205] = 2273;
        cArray[206] = 14466;
        cArray[207] = 10403;
        cArray[208] = 52093;
        cArray[209] = 56156;
        cArray[210] = 60223;
        cArray[211] = 64286;
        cArray[212] = 35833;
        cArray[213] = 39896;
        cArray[214] = 43963;
        cArray[215] = 48026;
        cArray[216] = 19061;
        cArray[217] = 23124;
        cArray[218] = 27191;
        cArray[219] = 31254;
        cArray[220] = 2801;
        cArray[221] = 6864;
        cArray[222] = 10931;
        cArray[223] = 14994;
        cArray[224] = 64814;
        cArray[225] = 60687;
        cArray[226] = 56684;
        cArray[227] = 52557;
        cArray[228] = 48554;
        cArray[229] = 44427;
        cArray[230] = 40424;
        cArray[231] = 36297;
        cArray[232] = 31782;
        cArray[233] = 27655;
        cArray[234] = 23652;
        cArray[235] = 19525;
        cArray[236] = 15522;
        cArray[237] = 11395;
        cArray[238] = 7392;
        cArray[239] = 3265;
        cArray[240] = 61215;
        cArray[241] = 65342;
        cArray[242] = 53085;
        cArray[243] = 57212;
        cArray[244] = 44955;
        cArray[245] = 49082;
        cArray[246] = 36825;
        cArray[247] = 40952;
        cArray[248] = 28183;
        cArray[249] = 32310;
        cArray[250] = 20053;
        cArray[251] = 24180;
        cArray[252] = 11923;
        cArray[253] = 16050;
        cArray[254] = 3793;
        cArray[255] = 7920;
        crc_tb = cArray;
        hexString = "0123456789ABCDEF";
    }

    public static boolean checkCRC(String resultValue) {
        boolean result = false;
        String firstValue = resultValue.substring(0, resultValue.length() - 2);
        String lastValue = resultValue.substring(resultValue.length() - 2);
        byte[] pByte = firstValue.getBytes();
        int returnV = CRCUtil.caluCRC(pByte);
        String lastV = CRCUtil.toHexString(lastValue);
        int reV = Integer.parseInt(lastV, 16);
        result = reV == returnV;
        return result;
    }

    public static byte[] getCRCByte(String command) {
        String crcStr = Integer.toHexString(CRCUtil.caluCRC(command.getBytes()));
        if (crcStr.length() == 2) {
            crcStr = "00" + crcStr;
        }
        if (crcStr.length() == 3) {
            crcStr = "0" + crcStr;
        }
        if (crcStr.length() % 2 != 0) {
            crcStr = "0" + crcStr;
        }
        byte[] baKeyword = new byte[crcStr.length() / 2];
        int i = 0;
        while (i < baKeyword.length) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(crcStr.substring(i * 2, i * 2 + 2), 16));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return baKeyword;
    }

    public static String getCRC(String command) {
        String crcStr = Integer.toHexString(CRCUtil.caluCRC(command.getBytes()));
        if (crcStr.length() % 2 != 0) {
            crcStr = "0" + crcStr;
        }
        String crc = CRCUtil.toStringHex(crcStr);
        while (crc.length() < 2) {
            crc = "0" + crc;
        }
        return crc;
    }

    public static String toHexString(String s) {
        String str = "";
        int i = 0;
        while (i < s.length()) {
            String s4;
            short ch = (short)s.charAt(i);
            if (ch < 0) {
                ch = (short)(ch + 256);
            }
            if ((s4 = Integer.toHexString(ch)).length() < 2) {
                s4 = "0" + s4;
            }
            str = String.valueOf(str) + s4;
            ++i;
        }
        return str;
    }

    public static int caluCRC(byte[] pByte) {
        try {
            int len = pByte.length;
            int i = 0;
            int crc = 0;
            while (len-- != 0) {
                int da = 0xFF & (0xFF & crc >> 8) >> 4;
                crc <<= 4;
                crc ^= crc_tb[0xFF & (da ^ pByte[i] >> 4)];
                da = 0xFF & (0xFF & crc >> 8) >> 4;
                crc <<= 4;
                int temp = 0xFF & (da ^ pByte[i] & 0xF);
                crc ^= crc_tb[temp];
                ++i;
            }
            int bCRCLow = 0xFF & crc;
            int bCRCHign = 0xFF & crc >> 8;
            if (bCRCLow == 40 || bCRCLow == 13 || bCRCLow == 10) {
                ++bCRCLow;
            }
            if (bCRCHign == 40 || bCRCHign == 13 || bCRCHign == 10) {
                ++bCRCHign;
            }
            crc = (0xFF & bCRCHign) << 8;
            return crc += bCRCLow;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static void main(String[] args) {
        String re = "QPI";
        System.out.println("CRCByte\u662f:" + CRCUtil.getCRCByte(re));
        byte[] bytes = re.getBytes();
        int ch = CRCUtil.caluCRC(bytes);
        System.out.println("Str:" + ch);
        int i = ch;
        String str = Integer.toHexString(i);
        System.out.println("CRC\u5341\u516d\u8fdb\u5236\u5b57\u7b26\u4e32\u662f:" + str);
        System.out.println("CRC\u5b57\u7b26\u4e32\u662f:" + CRCUtil.toStringHex(str));
        System.out.println("CRC\u6574\u6570\u7c7b\u578b\u7684\u6570\u636e\u662f:" + i);
    }

    public static String toStringHex(String s) {
        byte[] baKeyword = new byte[s.length() / 2];
        int i = 0;
        while (i < baKeyword.length) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            s = new String(baKeyword, "utf-8");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static String encode(String str) {
        byte[] bytes = str.getBytes();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            sb.append(hexString.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0xF) >> 0));
            ++i;
        }
        return sb.toString();
    }

    public static String decode(String bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        int i = 0;
        while (i < bytes.length()) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
            i += 2;
        }
        return new String(baos.toByteArray());
    }
}

