/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class HttpAdapterList<T extends HttpAdapter>
extends AbstractList<T>
implements DeploymentDescriptorParser.AdapterFactory<T> {
    private final List<T> adapters = new ArrayList<T>();
    private final Map<PortInfo, String> addressMap = new HashMap<PortInfo, String>();

    @Override
    public T createAdapter(String string, String string2, WSEndpoint<?> wSEndpoint) {
        T t = this.createHttpAdapter(string, string2, wSEndpoint);
        this.adapters.add(t);
        WSDLPort wSDLPort = wSEndpoint.getPort();
        if (wSDLPort != null) {
            PortInfo portInfo = new PortInfo(wSDLPort.getOwner().getName(), wSDLPort.getName().getLocalPart());
            this.addressMap.put(portInfo, this.getValidPath(string2));
        }
        return t;
    }

    protected abstract T createHttpAdapter(String var1, String var2, WSEndpoint<?> var3);

    private String getValidPath(@NotNull String string) {
        if (string.endsWith("/*")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    public PortAddressResolver createPortAddressResolver(final String string) {
        return new PortAddressResolver(){

            @Override
            public String getAddressFor(@NotNull QName qName, @NotNull String string3) {
                String string2 = (String)HttpAdapterList.this.addressMap.get(new PortInfo(qName, string3));
                return string2 == null ? null : string + string2;
            }
        };
    }

    @Override
    public T get(int n) {
        return (T)((HttpAdapter)this.adapters.get(n));
    }

    @Override
    public int size() {
        return this.adapters.size();
    }

    private static class PortInfo {
        private final QName serviceName;
        private final String portName;

        PortInfo(@NotNull QName qName, @NotNull String string) {
            this.serviceName = qName;
            this.portName = string;
        }

        public boolean equals(Object object) {
            if (object instanceof PortInfo) {
                PortInfo portInfo = (PortInfo)object;
                return this.serviceName.equals(portInfo.serviceName) && this.portName.equals(portInfo.portName);
            }
            return false;
        }

        public int hashCode() {
            return this.serviceName.hashCode() + this.portName.hashCode();
        }
    }
}

