/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.work;

import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.data.bean.SynchroEnergyPlan;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.work.SynchroHandler;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class HandSynchroThread
extends Thread {
    private List<String> _list;
    private Date _enddate;
    private SynchroEnergyPlan _plan;

    public HandSynchroThread(List<String> serialNos, Date enddate, SynchroEnergyPlan plan) {
        this._list = serialNos;
        this._enddate = enddate;
        this._plan = plan;
    }

    @Override
    public void run() {
        for (String serialno : this._list) {
            SystemEnv.energySynchroing = true;
            AbstractProcessor processor = GlobalProcessors.findProcessorBySerialno(serialno);
            if (processor == null) continue;
            SynchroEnergyPlan newPlan = new SynchroEnergyPlan();
            newPlan.setCycle(this._plan.getCycle());
            newPlan.setPlanMonth(this._plan.getPlanMonth());
            newPlan.setPlanTime(this._plan.getPlanTime());
            newPlan.setPlanWeek(this._plan.getPlanWeek());
            newPlan.setSynchroTime(this._plan.getSynchroTime());
            newPlan.setSerialno(serialno);
            Calendar machineTime = null;
            try {
                machineTime = processor.getCurrentTime();
                if (this._enddate == null && machineTime != null) {
                    this._enddate = machineTime.getTime();
                }
            }
            catch (Exception e) {
                this._enddate = new Date();
                e.printStackTrace();
            }
            Calendar ca = Calendar.getInstance();
            ca.setTime(this._enddate);
            if (machineTime != null) {
                ca.set(11, machineTime.get(11));
            } else {
                ca.set(11, Calendar.getInstance().get(11));
            }
            SynchroHandler handler = new SynchroHandler();
            handler.synchroEnergy(ca, newPlan, processor, false);
        }
        SystemEnv.energySynchroing = false;
    }
}

