/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.SecureCookiePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

final class BasicPermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 739301742472979399L;
    private transient Map perms = new HashMap(11);
    private boolean all_allowed = false;
    private Class permClass;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", class$java$util$Hashtable == null ? (class$java$util$Hashtable = BasicPermissionCollection.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("permClass", class$java$lang$Class == null ? (class$java$lang$Class = BasicPermissionCollection.class$("java.lang.Class")) : class$java$lang$Class)};
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$lang$Class;

    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.perms.size() == 0) {
            this.permClass = basicPermission.getClass();
        } else if (basicPermission.getClass() != this.permClass) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        this.perms.put(basicPermission.getName(), permission);
        if (!this.all_allowed && basicPermission.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (basicPermission.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        String string = basicPermission.getName();
        Permission permission2 = (Permission)this.perms.get(string);
        if (permission2 != null) {
            return permission2.implies(permission);
        }
        int n2 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n2)) != -1) {
            permission2 = (Permission)this.perms.get(string = string.substring(0, n + 1) + "*");
            if (permission2 != null) {
                return permission2.implies(permission);
            }
            n2 = n - 1;
        }
        if (!permission.getName().toLowerCase().startsWith(SecureCookiePermission.ORIGIN_PREFIX + "https:")) {
            return true;
        }
        Iterator iterator = this.perms.values().iterator();
        while (iterator.hasNext()) {
            Permission permission3 = (Permission)iterator.next();
            if (!permission3.getName().startsWith(SecureCookiePermission.ORIGIN_PREFIX) || !permission.getName().startsWith(SecureCookiePermission.ORIGIN_PREFIX)) continue;
            try {
                URL uRL = new URL(permission3.getName().substring(SecureCookiePermission.ORIGIN_PREFIX.length()));
                URL uRL2 = new URL(permission.getName().substring(SecureCookiePermission.ORIGIN_PREFIX.length()));
                if (!uRL.getProtocol().toLowerCase().equals(uRL2.getProtocol().toLowerCase()) || !uRL.getHost().equals(uRL2.getHost())) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms.values());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.perms.size() * 2);
        hashtable.putAll(this.perms);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("all_allowed", this.all_allowed);
        putField.put("permissions", hashtable);
        putField.put("permClass", this.permClass);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Enumeration enumeration;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.perms = new HashMap(hashtable.size() * 2);
        this.perms.putAll(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
        this.permClass = (Class)getField.get("permClass", null);
        if (this.permClass == null && (enumeration = hashtable.elements()).hasMoreElements()) {
            Permission permission = (Permission)enumeration.nextElement();
            this.permClass = permission.getClass();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

