/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.util.JAXWSUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;

final class SCAnnotations {
    QName serviceQName;
    final ArrayList<QName> portQNames = new ArrayList();
    final ArrayList<Class> classes = new ArrayList();
    URL wsdlLocation;

    SCAnnotations(final Class<?> clazz) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                WebServiceClient webServiceClient = clazz.getAnnotation(WebServiceClient.class);
                if (webServiceClient == null) {
                    throw new WebServiceException("Service Interface Annotations required, exiting...");
                }
                String string = webServiceClient.name();
                String string2 = webServiceClient.targetNamespace();
                SCAnnotations.this.serviceQName = new QName(string2, string);
                try {
                    SCAnnotations.this.wsdlLocation = JAXWSUtils.getFileOrURL(webServiceClient.wsdlLocation());
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                for (Method method : clazz.getDeclaredMethods()) {
                    Object object;
                    WebEndpoint webEndpoint = method.getAnnotation(WebEndpoint.class);
                    if (webEndpoint != null) {
                        object = webEndpoint.name();
                        QName qName = new QName(string2, (String)object);
                        SCAnnotations.this.portQNames.add(qName);
                    }
                    if ((object = method.getReturnType()) == Void.TYPE) continue;
                    SCAnnotations.this.classes.add((Class)object);
                }
                return null;
            }
        });
    }
}

