/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.InvalidObjectException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.UnexpectedException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;

public class RemoteObjectInvocationHandler
extends RemoteObject
implements InvocationHandler {
    private static final long serialVersionUID = 2L;
    private static final MethodToHash_Maps methodToHash_Maps = new MethodToHash_Maps();

    public RemoteObjectInvocationHandler(RemoteRef remoteRef) {
        super(remoteRef);
        if (remoteRef == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(object, method, objectArray);
        }
        return this.invokeRemoteMethod(object, method, objectArray);
    }

    private Object invokeObjectMethod(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("hashCode")) {
            return this.hashCode();
        }
        if (string.equals("equals")) {
            Object object2 = objectArray[0];
            return object == object2 || object2 != null && Proxy.isProxyClass(object2.getClass()) && this.equals(Proxy.getInvocationHandler(object2));
        }
        if (string.equals("toString")) {
            return this.proxyToString(object);
        }
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    private Object invokeRemoteMethod(Object object, Method method, Object[] objectArray) throws Exception {
        try {
            if (!(object instanceof Remote)) {
                throw new IllegalArgumentException("proxy not Remote instance");
            }
            return this.ref.invoke((Remote)object, method, objectArray, RemoteObjectInvocationHandler.getMethodHash(method));
        }
        catch (Exception exception) {
            UnexpectedException unexpectedException;
            if (!(exception instanceof RuntimeException)) {
                Class<?> clazz = object.getClass();
                try {
                    method = clazz.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw (IllegalArgumentException)new IllegalArgumentException().initCause(noSuchMethodException);
                }
                Class<?> clazz2 = exception.getClass();
                for (Class<?> clazz3 : method.getExceptionTypes()) {
                    if (!clazz3.isAssignableFrom(clazz2)) continue;
                    throw exception;
                }
                unexpectedException = new UnexpectedException("unexpected exception", exception);
            }
            throw unexpectedException;
        }
    }

    private String proxyToString(Object object) {
        int n;
        Class<?>[] classArray = object.getClass().getInterfaces();
        if (classArray.length == 0) {
            return "Proxy[" + this + "]";
        }
        String string = classArray[0].getName();
        if (string.equals("java.rmi.Remote") && classArray.length > 1) {
            string = classArray[1].getName();
        }
        if ((n = string.lastIndexOf(46)) >= 0) {
            string = string.substring(n + 1);
        }
        return "Proxy[" + string + "," + this + "]";
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream; class: " + this.getClass().getName());
    }

    private static long getMethodHash(Method method) {
        return (Long)((Map)methodToHash_Maps.get(method.getDeclaringClass())).get(method);
    }

    private static class MethodToHash_Maps
    extends WeakClassHashMap<Map<Method, Long>> {
        MethodToHash_Maps() {
        }

        @Override
        protected Map<Method, Long> computeValue(Class<?> clazz) {
            return new WeakHashMap<Method, Long>(){

                @Override
                public synchronized Long get(Object object) {
                    Long l = (Long)super.get(object);
                    if (l == null) {
                        Method method = (Method)object;
                        l = Util.computeMethodHash(method);
                        this.put(method, l);
                    }
                    return l;
                }
            };
        }
    }
}

